/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.util.ui.MacUIUtil;

public class EnterAction
extends EditorAction {
    public EnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void insertNewLineAtCaret(Editor editor) {
        int indentLineNum;
        MacUIUtil.hideCursor();
        if (!editor.isInsertMode()) {
            if (editor.getCaretModel().getLogicalPosition().line < editor.getDocument().getLineCount() - 1) {
                LogicalPosition pos = new LogicalPosition(editor.getCaretModel().getLogicalPosition().line + 1, 0);
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getSelectionModel().removeSelection();
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            return;
        }
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int lineLength = 0;
        if (document.getLineCount() > 0) {
            for (indentLineNum = editor.getCaretModel().getLogicalPosition().line; indentLineNum >= 0 && (lineLength = document.getLineEndOffset(indentLineNum) - document.getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
            }
        } else {
            indentLineNum = -1;
        }
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        StringBuilder buf = new StringBuilder();
        if (indentLineNum >= 0) {
            char c;
            int lineStartOffset = document.getLineStartOffset(indentLineNum);
            for (int i = 0; i < lineLength && ((c = text.charAt(lineStartOffset + i)) == ' ' || c == '\t') && i < colNumber; ++i) {
                buf.append(c);
            }
        }
        int caretOffset = editor.getCaretModel().getOffset();
        String s = "\n" + buf;
        document.insertString(caretOffset, (CharSequence)s);
        editor.getCaretModel().moveToOffset(caretOffset + s.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            EnterAction.insertNewLineAtCaret(editor);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isOneLineMode();
        }
    }
}

