/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.util.Disposer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SyncScrollSupport
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.SyncScrollSupport");
    private boolean myDuringVerticalScroll = false;
    @NotNull
    private final ArrayList<ScrollListener> myScrollers = new ArrayList();
    private boolean myEnabled = true;

    public void install(EditingSides[] sideContainers) {
        Disposer.dispose((Disposable)this);
        Editor[] editors = new Editor[sideContainers.length + 1];
        editors[0] = sideContainers[0].getEditor(FragmentSide.SIDE1);
        for (int i = 0; i < sideContainers.length; ++i) {
            EditingSides sideContainer = sideContainers[i];
            LOG.assertTrue(sideContainer.getEditor(FragmentSide.SIDE1) == editors[i]);
            editors[i + 1] = sideContainer.getEditor(FragmentSide.SIDE2);
        }
        if (editors.length == 3) {
            this.install3(editors, sideContainers);
        } else if (editors.length == 2) {
            this.install2(editors, sideContainers);
        } else {
            LOG.error(String.valueOf(editors.length));
        }
    }

    public void dispose() {
        for (ScrollListener scrollListener : this.myScrollers) {
            Disposer.dispose((Disposable)scrollListener);
        }
        this.myScrollers.clear();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void install2(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install2"));
        }
        if (sideContainers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install2"));
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE2));
    }

    private void install3(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install3"));
        }
        if (sideContainers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install3"));
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[2], new ScrollingContext(FragmentSide.SIDE2, sideContainers[1], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1));
    }

    private void addSlavesScroller(@NotNull Editor editor, ScrollingContext ... contexts) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "addSlavesScroller"));
        }
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "addSlavesScroller"));
        }
        ScrollListener scroller = new ScrollListener(contexts, editor);
        scroller.install();
        this.myScrollers.add(scroller);
    }

    private static void syncHorizontalScroll(@NotNull ScrollingContext context, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        FragmentSide masterSide;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        if (newRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        if (oldRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        int newScrollOffset = newRectangle.x;
        if (newScrollOffset == oldRectangle.x) {
            return;
        }
        EditingSides sidesContainer = context.getSidesContainer();
        Editor slaveEditor = sidesContainer.getEditor((masterSide = context.getMasterSide()).otherSide());
        if (slaveEditor == null) {
            return;
        }
        ScrollingModel scrollingModel = slaveEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollHorizontally(newScrollOffset);
        scrollingModel.enableAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncVerticalScroll(@NotNull ScrollingContext context, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (newRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (oldRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (newRectangle.y == oldRectangle.y && newRectangle.height == oldRectangle.height) {
            return;
        }
        EditingSides sidesContainer = context.getSidesContainer();
        FragmentSide masterSide = context.getMasterSide();
        FragmentSide masterDiffSide = context.getMasterDiffSide();
        Editor master = sidesContainer.getEditor(masterSide);
        Editor slave = sidesContainer.getEditor(masterSide.otherSide());
        if (master == null || slave == null) {
            return;
        }
        Rectangle viewRect = master.getScrollingModel().getVisibleArea();
        int middleY = viewRect.height / 3;
        int masterVerticalScrollOffset = SyncScrollSupport.getScrollOffset(master);
        int slaveVerticalScrollOffset = SyncScrollSupport.getScrollOffset(slave);
        LogicalPosition masterPos = master.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
        int masterCenterLine = masterPos.line;
        if (masterCenterLine > master.getDocument().getLineCount()) {
            masterCenterLine = master.getDocument().getLineCount();
        }
        int scrollToLine = sidesContainer.getLineBlocks().transform(masterDiffSide, masterCenterLine) + 1;
        int actualLine = scrollToLine - 1;
        slave.getScrollingModel().disableAnimation();
        try {
            if (scrollToLine <= 0) {
                int offset = newRectangle.y - oldRectangle.y;
                slave.getScrollingModel().scrollVertically(slaveVerticalScrollOffset + offset);
            } else {
                int correction = (masterVerticalScrollOffset + middleY) % master.getLineHeight();
                Point point = slave.logicalPositionToXY(new LogicalPosition(actualLine, masterPos.column));
                slave.getScrollingModel().scrollVertically(point.y - middleY + correction);
            }
        }
        finally {
            slave.getScrollingModel().enableAnimation();
        }
    }

    private static int getScrollOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "getScrollOffset"));
        }
        JComponent header = editor.getHeaderComponent();
        int headerOffset = header == null ? 0 : header.getHeight();
        return editor.getScrollingModel().getVerticalScrollOffset() - headerOffset;
    }

    public static void scrollEditor(@NotNull Editor editor, int logicalLine) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "scrollEditor"));
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logicalLine, 0));
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
    }

    private static class ScrollingContext {
        @NotNull
        private final EditingSides mySidesContainer;
        @NotNull
        private final FragmentSide myMasterSide;
        @NotNull
        private final FragmentSide myMasterDiffSide;

        public ScrollingContext(@NotNull FragmentSide masterSide, @NotNull EditingSides sidesContainer, @NotNull FragmentSide masterDiffSide) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            if (sidesContainer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            if (masterDiffSide == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            this.mySidesContainer = sidesContainer;
            this.myMasterSide = masterSide;
            this.myMasterDiffSide = masterDiffSide;
        }

        @NotNull
        public EditingSides getSidesContainer() {
            EditingSides editingSides = this.mySidesContainer;
            if (editingSides == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getSidesContainer"));
            }
            return editingSides;
        }

        @NotNull
        public FragmentSide getMasterSide() {
            FragmentSide fragmentSide = this.myMasterSide;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getMasterSide"));
            }
            return fragmentSide;
        }

        @NotNull
        public FragmentSide getMasterDiffSide() {
            FragmentSide fragmentSide = this.myMasterDiffSide;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getMasterDiffSide"));
            }
            return fragmentSide;
        }
    }

    private class ScrollListener
    implements VisibleAreaListener,
    Disposable {
        private ScrollingContext[] myScrollContexts;
        @NotNull
        private final Editor myEditor;

        public ScrollListener(@NotNull ScrollingContext[] scrollContexts, Editor editor) {
            if (scrollContexts == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollListener", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollListener", "<init>"));
            }
            this.myScrollContexts = scrollContexts;
            this.myEditor = editor;
        }

        public void install() {
            this.myEditor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        }

        public void dispose() {
            this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
            this.myScrollContexts = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!SyncScrollSupport.this.myEnabled || SyncScrollSupport.this.myDuringVerticalScroll) {
                return;
            }
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (newRectangle == null || oldRectangle == null) {
                return;
            }
            SyncScrollSupport.this.myDuringVerticalScroll = true;
            try {
                for (ScrollingContext context : this.myScrollContexts) {
                    SyncScrollSupport.syncVerticalScroll(context, newRectangle, oldRectangle);
                    SyncScrollSupport.syncHorizontalScroll(context, newRectangle, oldRectangle);
                }
            }
            finally {
                SyncScrollSupport.this.myDuringVerticalScroll = false;
            }
        }
    }
}

