/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.text.StringUtil;

class PreferWholeLines
implements DiffCorrection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.processing.PreferWholeLines");
    public static final DiffCorrection INSTANCE = new PreferWholeLines();

    PreferWholeLines() {
    }

    public DiffFragment[] correct(DiffFragment[] fragments) {
        for (int i = 1; i < fragments.length - 1; ++i) {
            DiffFragment fragment = fragments[i];
            if (!fragment.isOneSide()) continue;
            DiffFragment nextFragment = fragments[i + 1];
            FragmentSide side = FragmentSide.chooseSide((DiffFragment)fragment);
            DiffString fragmentText = side.getText(fragment);
            DiffString otherNextFragmentText = side.getOtherText(nextFragment);
            DiffString nextFragmentText = side.getText(nextFragment);
            if (nextFragment.isOneSide()) {
                LOG.error("<" + fragmentText + "> <" + otherNextFragmentText + ">");
            }
            if (!StringUtil.startsWithChar((CharSequence)fragmentText, (char)'\n') || !StringUtil.startsWithChar((CharSequence)nextFragmentText, (char)'\n') || !StringUtil.startsWithChar((CharSequence)otherNextFragmentText, (char)'\n')) continue;
            DiffFragment previous = fragments[i - 1];
            DiffString previousText = side.getText(previous);
            DiffString otherPreciousText = side.getOtherText(previous);
            assert (previous != null);
            assert (previousText != null);
            assert (otherPreciousText != null);
            assert (fragmentText != null);
            assert (nextFragmentText != null);
            assert (otherNextFragmentText != null);
            fragments[i - 1] = previous = side.createFragment(previousText.append('\n'), otherPreciousText.append('\n'), previous.isModified());
            fragments[i] = fragment = side.createFragment(fragmentText.substring(1).append('\n'), side.getOtherText(fragment), fragment.isModified());
            fragments[i + 1] = nextFragment = side.createFragment(nextFragmentText.substring(1), otherNextFragmentText.substring(1), nextFragment.isModified());
        }
        return fragments;
    }
}

