/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.CharsetEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Nullable;

public class ApplyTextFilePatch
extends ApplyFilePatchBase<TextFilePatch> {
    public ApplyTextFilePatch(TextFilePatch patch) {
        super(patch);
    }

    @Override
    @Nullable
    protected ApplyFilePatch.Result applyChange(final Project project, final VirtualFile fileToPatch, final FilePath pathBeforeRename, final Getter<CharSequence> baseContents) throws IOException {
        byte[] fileContents = fileToPatch.contentsToByteArray();
        CharSequence text = LoadTextUtil.getTextByBinaryPresentation(fileContents, fileToPatch);
        GenericPatchApplier applier = new GenericPatchApplier(text, ((TextFilePatch)this.myPatch).getHunks());
        if (applier.execute()) {
            Document document = FileDocumentManager.getInstance().getDocument(fileToPatch);
            if (document == null) {
                throw new IOException("Failed to set contents for updated file " + fileToPatch.getPath());
            }
            document.setText((CharSequence)applier.getAfter());
            FileDocumentManager.getInstance().saveDocument(document);
            return new ApplyFilePatch.Result(applier.getStatus()){

                @Override
                public ApplyPatchForBaseRevisionTexts getMergeData() {
                    return null;
                }
            };
        }
        applier.trySolveSomehow();
        return new ApplyFilePatch.Result(ApplyPatchStatus.FAILURE){

            @Override
            public ApplyPatchForBaseRevisionTexts getMergeData() {
                return ApplyPatchForBaseRevisionTexts.create(project, fileToPatch, pathBeforeRename, (TextFilePatch)ApplyTextFilePatch.this.myPatch, (Getter<CharSequence>)baseContents);
            }
        };
    }

    @Override
    protected void applyCreate(VirtualFile newFile, CommitContext commitContext) throws IOException {
        Document document = FileDocumentManager.getInstance().getDocument(newFile);
        if (document == null) {
            throw new IOException("Failed to set contents for new file " + newFile.getPath());
        }
        String charsetName = CharsetEP.getCharset((String)newFile.getPath(), (CommitContext)commitContext);
        if (charsetName != null) {
            try {
                Charset charset = Charset.forName(charsetName);
                newFile.setCharset(charset);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        document.setText((CharSequence)((TextFilePatch)this.myPatch).getNewFileText());
        FileDocumentManager.getInstance().saveDocument(document);
    }
}

