/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public interface MergeVersion {
    public Document createWorkingDocument(Project var1);

    public void applyText(String var1, Project var2);

    public VirtualFile getFile();

    public byte[] getBytes() throws IOException;

    public FileType getContentType();

    public void restoreOriginalContent(Project var1);

    public static class MergeDocumentVersion
    implements MergeVersion {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeVersion.MergeDocumentVersion");
        protected final Document myDocument;
        private final String myOriginalText;
        private String myTextBeforeMerge;

        public MergeDocumentVersion(Document document, String originalText) {
            LOG.assertTrue(originalText != null, (Object)"text should not be null");
            LOG.assertTrue(document != null, (Object)"document should not be null");
            LOG.assertTrue(document.isWritable(), (Object)"document should be writable");
            this.myDocument = document;
            this.myOriginalText = originalText;
        }

        @Override
        public Document createWorkingDocument(final Project project) {
            final Document workingDocument = this.myDocument;
            workingDocument.setReadOnly(false);
            final DocumentReference ref = DocumentReferenceManager.getInstance().create(workingDocument);
            this.myTextBeforeMerge = this.myDocument.getText();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    UndoManager undoManager;
                    MergeDocumentVersion.setDocumentText(workingDocument, MergeDocumentVersion.this.myOriginalText, DiffBundle.message((String)"merge.init.merge.content.command.name", (Object[])new Object[0]), project);
                    if (project != null && (undoManager = UndoManager.getInstance((Project)project)) != null) {
                        undoManager.nonundoableActionPerformed(ref, false);
                    }
                }
            });
            return workingDocument;
        }

        @Override
        public void applyText(final String text, final Project project) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            MergeDocumentVersion.this.doApplyText(text, project);
                        }
                    }, "Merge changes", null);
                }
            });
        }

        protected void doApplyText(String text, Project project) {
            MergeDocumentVersion.setDocumentText(this.myDocument, text, DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]), project);
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
            VirtualFile file = this.getFile();
            MergeDocumentVersion.reportProjectFileChangeIfNeeded(project, file);
        }

        public static void reportProjectFileChangeIfNeeded(Project project, VirtualFile file) {
            if (file != null && !file.isDirectory() && (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file) || MergeDocumentVersion.isProjectFile(file))) {
                ProjectManagerEx.getInstanceEx().saveChangedProjectFile(file, project);
            }
        }

        @Nullable
        public static Runnable prepareToReportChangedProjectFiles(final Project project, Collection<VirtualFile> files) {
            final HashSet<VirtualFile> vfs = new HashSet<VirtualFile>();
            for (VirtualFile vf : files) {
                if (vf == null || vf.isDirectory() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)vf) && !MergeDocumentVersion.isProjectFile(vf)) continue;
                vfs.add(vf);
            }
            return vfs.isEmpty() ? null : new Runnable(){

                @Override
                public void run() {
                    ProjectManagerEx ex = ProjectManagerEx.getInstanceEx();
                    for (VirtualFile vf : vfs) {
                        ex.saveChangedProjectFile(vf, project);
                    }
                }
            };
        }

        @Override
        public void restoreOriginalContent(final Project project) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    MergeDocumentVersion.this.doRestoreOriginalContent(project);
                }
            });
        }

        public static boolean isProjectFile(VirtualFile file) {
            ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file);
            return importProvider != null && importProvider.lookForProjectsInDirectory();
        }

        protected void doRestoreOriginalContent(Project project) {
            MergeDocumentVersion.setDocumentText(this.myDocument, this.myTextBeforeMerge, "", project);
        }

        @Override
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myDocument);
        }

        @Override
        public byte[] getBytes() throws IOException {
            VirtualFile file = this.getFile();
            if (file != null) {
                return file.contentsToByteArray();
            }
            return this.myDocument.getText().getBytes();
        }

        @Override
        public FileType getContentType() {
            VirtualFile file = this.getFile();
            if (file == null) {
                return FileTypes.PLAIN_TEXT;
            }
            return file.getFileType();
        }

        private static void setDocumentText(final Document document, final String text, String name, Project project) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
                }
            }, name, null);
        }
    }
}

