/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    public MergeRequest createMergeRequest(String leftText, String rightText, String originalContent, @NotNull VirtualFile file, Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null) {
            return new MergeRequestImpl(leftText, (MergeVersion)new MergeVersion.MergeDocumentVersion(document, originalContent), rightText, project, okButtonPresentation, cancelButtonPresentation);
        }
        return this.create3WayDiffRequest(leftText, rightText, originalContent, project, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequest create3WayDiffRequest(String leftText, String rightText, String originalContent, Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        return new MergeRequestImpl(leftText, originalContent, rightText, project, okButtonPresentation, cancelButtonPresentation);
    }
}

