/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanelColumn;
import com.intellij.openapi.diff.impl.splitter.DividerPolygon;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorPlace
extends JComponent
implements Disposable,
EditorEx.RepaintCallback {
    private static final Logger LOG = Logger.getInstance(EditorPlace.class);
    @NotNull
    private final MergePanel2.DiffEditorState myState;
    @NotNull
    private final MergePanelColumn myColumn;
    @NotNull
    private final MergePanel2 myMergePanel;
    @NotNull
    private final List<EditorListener> myListeners;
    @Nullable
    private EditorEx myEditor;

    public EditorPlace(@NotNull MergePanel2.DiffEditorState state, @NotNull MergePanelColumn column, @NotNull MergePanel2 mergePanel) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        if (mergePanel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myState = state;
        this.myColumn = column;
        this.myMergePanel = mergePanel;
        this.setLayout(new BorderLayout());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintThis(g);
    }

    @Override
    public void call(Graphics g) {
        this.repaintScrollbar();
    }

    private void repaintScrollbar() {
        if (this.myEditor == null || this.myColumn != MergePanelColumn.BASE) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        this.repaint(((Component)editorComponent).getWidth() - scrollBar.getWidth(), 0, scrollBar.getWidth(), scrollBar.getHeight());
    }

    private void paintThis(Graphics g) {
        if (this.myEditor != null) {
            ArrayList<DividerPolygon> polygons = DividerPolygon.createVisiblePolygons(this.myMergePanel.getSecondEditingSide(), FragmentSide.SIDE1, 1);
            for (DividerPolygon polygon : polygons) {
                int startY = polygon.getTopLeftY();
                int endY = polygon.getBottomLeftY();
                int height = endY - startY;
                if (height == 0) {
                    height = 1;
                }
                this.drawPolygonAboveScrollBar((Graphics2D)g, startY, height, polygon.getColor(), polygon.isApplied());
            }
        }
    }

    private void drawPolygonAboveScrollBar(@NotNull Graphics2D g, int startY, int height, @NotNull Color color, boolean applied) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "drawPolygonAboveScrollBar"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "drawPolygonAboveScrollBar"));
        }
        if (this.myColumn != MergePanelColumn.BASE) {
            return;
        }
        g.setColor(color);
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        int startX = scrollBar.getX();
        int endX = startX + scrollBar.getWidth() - 1;
        Rectangle thumb = EditorPlace.calcThumbBounds(scrollBar);
        int endY = startY + height;
        if (!applied) {
            if (height > 2) {
                EditorPlace.fillRectAboveScrollBar(g, startX, startY, scrollBar.getWidth(), height, thumb);
                Color framingColor = DiffUtil.getFramingColor(color);
                if (EditorPlace.outsideBounds(startY, thumb)) {
                    UIUtil.drawLine((Graphics2D)g, (int)startX, (int)startY, (int)endX, (int)startY, null, (Color)framingColor);
                }
                if (EditorPlace.outsideBounds(endY, thumb)) {
                    UIUtil.drawLine((Graphics2D)g, (int)startX, (int)endY, (int)endX, (int)endY, null, (Color)framingColor);
                }
            } else if (EditorPlace.outsideBounds(startY, thumb)) {
                DiffUtil.drawDoubleShadowedLine(g, startX, endX, startY, color);
            }
        } else {
            if (EditorPlace.outsideBounds(startY, thumb)) {
                UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)startY, null, (Color)color, (boolean)false);
            }
            if (EditorPlace.outsideBounds(endY, thumb)) {
                UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)endY, null, (Color)color, (boolean)false);
            }
        }
    }

    private static void fillRectAboveScrollBar(Graphics2D g, int startX, int startY, int width, int height, Rectangle thumb) {
        int thumbEndY;
        int endY = startY + height;
        int n = thumbEndY = thumb == null ? 0 : thumb.y + thumb.height;
        if (thumb == null) {
            g.fillRect(startX, startY, width, height);
        } else if (EditorPlace.outsideBounds(startY, thumb) && !EditorPlace.outsideBounds(endY, thumb)) {
            g.fillRect(startX, startY, width, thumb.y - startY);
        } else if (!EditorPlace.outsideBounds(startY, thumb) && EditorPlace.outsideBounds(endY, thumb)) {
            g.fillRect(startX, thumbEndY, width, endY - thumbEndY);
        } else if (startY < thumb.y && endY > thumbEndY) {
            g.fillRect(startX, startY, width, thumb.y - startY);
            g.fillRect(startX, thumbEndY, width, endY - thumbEndY);
        } else if (EditorPlace.outsideBounds(startY, thumb) && EditorPlace.outsideBounds(endY, thumb)) {
            g.fillRect(startX, startY, width, height);
        }
    }

    private static boolean outsideBounds(int y, @Nullable Rectangle rectangle) {
        if (rectangle == null) {
            return true;
        }
        return y < rectangle.y || y > rectangle.y + rectangle.height;
    }

    @Nullable
    private static Rectangle calcThumbBounds(JScrollBar scrollBar) {
        ScrollBarUI scrollBarUI = scrollBar.getUI();
        if (scrollBarUI instanceof ButtonlessScrollBarUI) {
            return ((ButtonlessScrollBarUI)scrollBarUI).getThumbBounds();
        }
        return null;
    }

    @Override
    public void addNotify() {
        if (this.myEditor != null) {
            super.addNotify();
            return;
        }
        this.createEditor();
        super.addNotify();
        this.revalidate();
    }

    private void createEditor() {
        LOG.assertTrue(this.myEditor == null);
        this.myEditor = this.myState.createEditor();
        if (this.myEditor == null) {
            return;
        }
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.myEditor.registerScrollBarRepaintCallback(this);
        this.repaint();
        this.fireEditorCreated();
    }

    public void addListener(EditorListener listener) {
        this.myListeners.add(listener);
    }

    private void fireEditorCreated() {
        for (EditorListener listener : this.myListeners) {
            listener.onEditorCreated(this);
        }
    }

    private void fireEditorReleased(Editor releasedEditor) {
        for (EditorListener listener : this.myListeners) {
            listener.onEditorReleased(releasedEditor);
        }
    }

    @Override
    public void removeNotify() {
        this.removeEditor();
        super.removeNotify();
    }

    private void removeEditor() {
        if (this.myEditor != null) {
            this.myEditor.registerScrollBarRepaintCallback(null);
            EditorEx releasedEditor = this.myEditor;
            this.remove(this.myEditor.getComponent());
            EditorPlace.getEditorFactory().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
            this.fireEditorReleased(releasedEditor);
        }
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public void setDocument(@Nullable Document document) {
        if (document == this.getDocument()) {
            return;
        }
        this.removeEditor();
        this.myState.setDocument(document);
        this.createEditor();
    }

    private Document getDocument() {
        return this.myState.getDocument();
    }

    @NotNull
    public MergePanel2.DiffEditorState getState() {
        MergePanel2.DiffEditorState diffEditorState = this.myState;
        if (diffEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace", "getState"));
        }
        return diffEditorState;
    }

    private static EditorFactory getEditorFactory() {
        return EditorFactory.getInstance();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.myEditor == null ? null : this.myEditor.getContentComponent();
    }

    public void dispose() {
        this.removeEditor();
    }

    public static interface EditorListener {
        public void onEditorCreated(EditorPlace var1);

        public void onEditorReleased(Editor var1);
    }
}

