/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

final class MergeFragment {
    @NotNull
    private final TextRange myLeft;
    @NotNull
    private final TextRange myBase;
    @NotNull
    private final TextRange myRight;

    MergeFragment(@NotNull TextRange left, @NotNull TextRange base, @NotNull TextRange right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "<init>"));
        }
        this.myLeft = left;
        this.myBase = base;
        this.myRight = right;
    }

    @NotNull
    TextRange getLeft() {
        TextRange textRange = this.myLeft;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "getLeft"));
        }
        return textRange;
    }

    @NotNull
    TextRange getBase() {
        TextRange textRange = this.myBase;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "getBase"));
        }
        return textRange;
    }

    @NotNull
    TextRange getRight() {
        TextRange textRange = this.myRight;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeFragment", "getRight"));
        }
        return textRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeFragment fragment = (MergeFragment)o;
        if (!this.myBase.equals((Object)fragment.myBase)) {
            return false;
        }
        if (!this.myLeft.equals((Object)fragment.myLeft)) {
            return false;
        }
        return this.myRight.equals((Object)fragment.myRight);
    }

    public int hashCode() {
        int result = this.myLeft.hashCode();
        result = 31 * result + this.myBase.hashCode();
        result = 31 * result + this.myRight.hashCode();
        return result;
    }

    public String toString() {
        return "<" + this.myLeft.toString() + ", " + this.myBase.toString() + ", " + this.myRight.toString() + ">";
    }
}

