/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.BeforeAfter;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PresetBlocksDiffPolicy
implements DiffPolicy {
    private List<BeforeAfter<TextRange>> myRanges;
    @NotNull
    private final DiffPolicy myDelegate;

    public PresetBlocksDiffPolicy(@NotNull DiffPolicy delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @NotNull
    public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create((String)text1), DiffString.create((String)text2));
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        return diffFragmentArray;
    }

    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (int i = 0; i < this.myRanges.size(); ++i) {
            BeforeAfter<TextRange> range = this.myRanges.get(i);
            fragments.addAll(Arrays.asList(this.myDelegate.buildFragments(text1.substring(((TextRange)range.getBefore()).getStartOffset(), ((TextRange)range.getBefore()).getEndOffset()).copy(), text2.substring(((TextRange)range.getAfter()).getStartOffset(), ((TextRange)range.getAfter()).getEndOffset()).copy())));
        }
        DiffFragment[] diffFragmentArray = fragments.toArray(new DiffFragment[fragments.size()]);
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/highlighting/PresetBlocksDiffPolicy", "buildFragments"));
        }
        return diffFragmentArray;
    }

    public void setRanges(List<BeforeAfter<TextRange>> ranges) {
        this.myRanges = ranges;
    }
}

