/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.DiffVersionComponent;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.ContentDocumentListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class EditorPlaceHolder
extends DiffMarkup
implements DiffVersionComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.highlighting.EditorWrapper");
    private EditorEx myEditor;
    private DiffContent myContent;
    private final FragmentSide mySide;
    private ContentChangeListener myListener;
    private FileEditor myFileEditor;
    private FileEditorProvider myFileEditorProvider;

    public EditorPlaceHolder(FragmentSide side, Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/highlighting/EditorPlaceHolder", "<init>"));
        }
        super(project, parentDisposable);
        this.myListener = null;
        this.mySide = side;
        this.resetHighlighters();
    }

    public void addListener(ContentChangeListener listener) {
        LOG.assertTrue(this.myListener == null);
        this.myListener = listener;
    }

    @Override
    protected void onDisposed() {
        LOG.assertTrue(!this.isDisposed());
        super.onDisposed();
        this.fireContentChanged();
    }

    private void fireContentChanged() {
        this.myListener.onContentChangedIn(this);
    }

    public void setContent(DiffContent content) {
        this.runRegisteredDisposables();
        this.myContent = content;
        if (this.myContent != null) {
            Document document = this.myContent.getDocument();
            if (this.myContent.isBinary() || document == null || this.myContent.getContentType() instanceof UIBasedFileType) {
                VirtualFile file = this.myContent.getFile();
                if (file != null) {
                    FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.getProject(), file);
                    if (providers.length > 0) {
                        this.myFileEditor = providers[0].createEditor(this.getProject(), file);
                        if (this.myFileEditor instanceof TextEditor) {
                            this.myEditor = (EditorEx)((TextEditor)this.myFileEditor).getEditor();
                            ContentDocumentListener.install(this.myContent, this);
                        }
                        this.myFileEditorProvider = providers[0];
                        this.addDisposable(new Disposable(){

                            public void dispose() {
                                EditorPlaceHolder.this.myFileEditorProvider.disposeEditor(EditorPlaceHolder.this.myFileEditor);
                                EditorPlaceHolder.this.myFileEditor = null;
                                EditorPlaceHolder.this.myFileEditorProvider = null;
                                EditorPlaceHolder.this.myEditor = null;
                            }
                        });
                    } else {
                        document = new DocumentImpl("Can not show", true);
                        final EditorFactory editorFactory = EditorFactory.getInstance();
                        this.myEditor = DiffUtil.createEditor(document, this.getProject(), true);
                        this.addDisposable(new Disposable(){

                            public void dispose() {
                                editorFactory.releaseEditor((Editor)EditorPlaceHolder.this.myEditor);
                                EditorPlaceHolder.this.myEditor = null;
                            }
                        });
                    }
                }
            } else {
                final EditorFactory editorFactory = EditorFactory.getInstance();
                this.myEditor = DiffUtil.createEditor(document, this.getProject(), false);
                this.addDisposable(new Disposable(){

                    public void dispose() {
                        editorFactory.releaseEditor((Editor)EditorPlaceHolder.this.myEditor);
                        EditorPlaceHolder.this.myEditor = null;
                    }
                });
                ContentDocumentListener.install(this.myContent, this);
            }
        }
        this.fireContentChanged();
    }

    @Override
    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Override
    public FragmentSide getSide() {
        return this.mySide;
    }

    @Override
    public DiffContent getContent() {
        return this.myContent;
    }

    @Override
    public void removeContent() {
        this.setContent(null);
    }

    @Override
    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }
}

