/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.external.BaseExternalTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.ExternalToolContentExternalizer;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ExtMergeFiles
extends BaseExternalTool {
    public static final ExtMergeFiles INSTANCE = new ExtMergeFiles();

    protected ExtMergeFiles() {
        super(DiffManagerImpl.ENABLE_MERGE, DiffManagerImpl.MERGE_TOOL);
    }

    @Override
    public boolean isAvailable(DiffRequest request) {
        DiffContent[] contents = request.getContents();
        if (contents.length != 3) {
            return false;
        }
        if (this.externalize(request, 0) == null) {
            return false;
        }
        if (this.externalize(request, 1) == null) {
            return false;
        }
        return this.externalize(request, 2) != null;
    }

    @Override
    protected List<String> getParameters(DiffRequest request) throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        String result = ((MergeRequestImpl)request).getResultContent().getFile().getPath();
        String left = this.externalize(request, 0).getContentFile().getPath();
        String base = new ExternalToolContentExternalizer(request, 1).getContentFile().getPath();
        String right = this.externalize(request, 2).getContentFile().getPath();
        for (String param : StringUtil.split((String)((String)DiffManagerImpl.MERGE_TOOL_PARAMETERS.get(ExtMergeFiles.getProperties())), (String)" ")) {
            if ("%1".equals(param)) {
                params.add(left);
                continue;
            }
            if ("%2".equals(param)) {
                params.add(base);
                continue;
            }
            if ("%3".equals(param)) {
                params.add(right);
                continue;
            }
            if ("%4".equals(param)) {
                params.add(result);
                continue;
            }
            params.add(param);
        }
        return params;
    }
}

