/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.util.text.DateFormatUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffElementImpl
implements DirDiffElement {
    private DTree myParent;
    private DiffType myType;
    private DiffElement mySource;
    private long mySourceLength;
    private DiffElement myTarget;
    private long myTargetLength;
    private String myName;
    private DirDiffOperation myOperation;
    private DirDiffOperation myDefaultOperation;
    private DTree myNode;

    private DirDiffElementImpl(DTree parent, @Nullable DiffElement source, @Nullable DiffElement target, DiffType type, String name, @Nullable DirDiffOperation defaultOperation) {
        this.myParent = parent.getParent();
        this.myNode = parent;
        this.myType = type;
        this.mySource = source;
        this.mySourceLength = source == null || source.isContainer() ? -1L : source.getSize();
        this.myTarget = target;
        this.myTargetLength = target == null || target.isContainer() ? -1L : target.getSize();
        this.myName = name;
        if (defaultOperation != null) {
            this.myDefaultOperation = defaultOperation;
        } else if (type == DiffType.ERROR) {
            this.myDefaultOperation = DirDiffOperation.NONE;
        } else if (this.isSource()) {
            this.myDefaultOperation = DirDiffOperation.COPY_TO;
        } else if (this.isTarget()) {
            this.myDefaultOperation = DirDiffOperation.COPY_FROM;
        } else if (type == DiffType.EQUAL) {
            this.myDefaultOperation = DirDiffOperation.EQUAL;
        } else if (type == DiffType.CHANGED) {
            assert (source != null);
            this.myDefaultOperation = DirDiffOperation.MERGE;
        }
    }

    public String getSourceModificationDate() {
        return this.mySource == null ? "" : DirDiffElementImpl.getLastModification(this.mySource);
    }

    public String getTargetModificationDate() {
        return this.myTarget == null ? "" : DirDiffElementImpl.getLastModification(this.myTarget);
    }

    public void updateTargetData() {
        this.myTargetLength = this.myTarget != null && !this.myTarget.isContainer() ? this.myTarget.getSize() : -1L;
    }

    private static String getLastModification(DiffElement file) {
        long timeStamp = file.getTimeStamp();
        return timeStamp < 0L ? "" : DateFormatUtil.formatDateTime((long)timeStamp);
    }

    public static DirDiffElementImpl createChange(DTree parent, @NotNull DiffElement source, @NotNull DiffElement target, @Nullable DirDiffSettings.CustomSourceChooser customSourceChooser) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createChange"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createChange"));
        }
        DirDiffOperation defaultOperation = null;
        if (customSourceChooser != null) {
            DiffElement chosenSource = customSourceChooser.chooseSource(source, target);
            if (chosenSource == source) {
                defaultOperation = DirDiffOperation.COPY_TO;
            } else if (chosenSource == target) {
                defaultOperation = DirDiffOperation.COPY_FROM;
            }
        }
        return new DirDiffElementImpl(parent, source, target, DiffType.CHANGED, source.getName(), defaultOperation);
    }

    public static DirDiffElementImpl createError(DTree parent, @Nullable DiffElement source, @Nullable DiffElement target) {
        return new DirDiffElementImpl(parent, source, target, DiffType.ERROR, source == null ? target.getName() : source.getName(), null);
    }

    public static DirDiffElementImpl createSourceOnly(DTree parent, @NotNull DiffElement source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createSourceOnly"));
        }
        return new DirDiffElementImpl(parent, source, null, DiffType.SOURCE, null, null);
    }

    public static DirDiffElementImpl createTargetOnly(DTree parent, @NotNull DiffElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createTargetOnly"));
        }
        return new DirDiffElementImpl(parent, null, target, DiffType.TARGET, null, null);
    }

    public static DirDiffElementImpl createDirElement(DTree parent, DiffElement src, DiffElement trg, String name) {
        return new DirDiffElementImpl(parent, src, trg, DiffType.SEPARATOR, name, null);
    }

    public static DirDiffElementImpl createEqual(DTree parent, @NotNull DiffElement source, @NotNull DiffElement target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createEqual"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "createEqual"));
        }
        return new DirDiffElementImpl(parent, source, target, DiffType.EQUAL, source.getName(), null);
    }

    public DiffType getType() {
        return this.myType;
    }

    public DiffElement getSource() {
        return this.mySource;
    }

    public DiffElement getTarget() {
        return this.myTarget;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getSourceName() {
        return this.myType == DiffType.CHANGED || this.myType == DiffType.SOURCE || this.myType == DiffType.EQUAL ? this.mySource.getName() : (this.mySource == null ? null : this.mySource.getName());
    }

    @Nullable
    public String getSourceSize() {
        return this.mySourceLength < 0L ? null : String.valueOf(this.mySourceLength);
    }

    public DirDiffOperation getDefaultOperation() {
        return this.myDefaultOperation;
    }

    @Nullable
    public String getTargetName() {
        return this.myType == DiffType.CHANGED || this.myType == DiffType.TARGET || this.myType == DiffType.EQUAL ? this.myTarget.getName() : (this.myTarget == null ? null : this.myTarget.getName());
    }

    @Nullable
    public String getTargetSize() {
        return this.myTargetLength < 0L ? null : String.valueOf(this.myTargetLength);
    }

    public boolean isSeparator() {
        return this.myType == DiffType.SEPARATOR;
    }

    public boolean isSource() {
        return this.myType == DiffType.SOURCE;
    }

    public boolean isTarget() {
        return this.myType == DiffType.TARGET;
    }

    public DirDiffOperation getOperation() {
        return this.myOperation == null ? this.myDefaultOperation : this.myOperation;
    }

    public void updateSourceFromTarget(DiffElement target) {
        this.myTarget = target;
        this.myTargetLength = this.mySourceLength;
        this.myDefaultOperation = DirDiffOperation.EQUAL;
        this.myOperation = DirDiffOperation.EQUAL;
        this.myType = DiffType.EQUAL;
    }

    public void updateTargetFromSource(DiffElement source) {
        this.mySource = source;
        this.mySourceLength = this.myTargetLength;
        this.myDefaultOperation = DirDiffOperation.EQUAL;
        this.myOperation = DirDiffOperation.EQUAL;
        this.myType = DiffType.EQUAL;
    }

    public void setNextOperation() {
        DirDiffOperation op = this.getOperation();
        if (this.myType == DiffType.SOURCE) {
            this.myOperation = op == DirDiffOperation.COPY_TO ? DirDiffOperation.DELETE : (op == DirDiffOperation.DELETE ? DirDiffOperation.NONE : DirDiffOperation.COPY_TO);
        } else if (this.myType == DiffType.TARGET) {
            this.myOperation = op == DirDiffOperation.COPY_FROM ? DirDiffOperation.DELETE : (op == DirDiffOperation.DELETE ? DirDiffOperation.NONE : DirDiffOperation.COPY_FROM);
        } else if (this.myType == DiffType.CHANGED) {
            this.myOperation = op == DirDiffOperation.MERGE ? DirDiffOperation.COPY_TO : (op == DirDiffOperation.COPY_TO ? DirDiffOperation.COPY_FROM : DirDiffOperation.MERGE);
        }
    }

    public void setOperation(@NotNull DirDiffOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl", "setOperation"));
        }
        if (this.myType == DiffType.EQUAL || this.myType == DiffType.SEPARATOR) {
            return;
        }
        if (this.myType == DiffType.TARGET && operation == DirDiffOperation.COPY_TO) {
            return;
        }
        if (this.myType == DiffType.SOURCE && operation == DirDiffOperation.COPY_FROM) {
            return;
        }
        if (this.myType == DiffType.CHANGED && operation == DirDiffOperation.DELETE) {
            return;
        }
        this.myOperation = operation;
    }

    public Icon getSourceIcon() {
        return DirDiffElementImpl.getIcon(this.mySource);
    }

    public Icon getTargetIcon() {
        return DirDiffElementImpl.getIcon(this.myTarget);
    }

    private static Icon getIcon(DiffElement element) {
        return element != null ? element.getIcon() : null;
    }

    public DTree getParentNode() {
        return this.myParent;
    }

    public DTree getNode() {
        return this.myNode;
    }
}

