/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.ErrorDiffViewer;
import com.intellij.openapi.diff.impl.external.DiscloseMultiRequest;
import com.intellij.openapi.diff.impl.external.MultiLevelDiffTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeDiffPanel
implements DiffViewer {
    private static final String FICTIVE_KEY = "FICTIVE_KEY";
    private static final int ourBadHackMagicContentsNumber = 101;
    private final RunnerLayoutUi myUi;
    private final DiscloseMultiRequest myRequest;
    private final Window myWindow;
    private final Disposable myParentDisposable;
    private final Map<String, DiffViewer> myMap;

    public CompositeDiffPanel(Project project, DiscloseMultiRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/impl/CompositeDiffPanel", "<init>"));
        }
        this.myRequest = request;
        this.myWindow = window;
        this.myParentDisposable = parentDisposable;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("Diff", "Diff", "Diff", parentDisposable);
        this.myUi.getComponent().setBorder(null);
        this.myUi.getOptions().setMinimizeActionEnabled(false);
        this.myMap = new HashMap<String, DiffViewer>();
    }

    public boolean canShowRequest(DiffRequest request) {
        return MultiLevelDiffTool.canShowRequest(request);
    }

    public void setDiffRequest(DiffRequest request) {
        Map<String, DiffRequest> requestMap = this.myRequest.discloseRequest(request);
        HashMap<String, DiffViewer> copy = new HashMap<String, DiffViewer>(this.myMap);
        for (Map.Entry<String, DiffRequest> entry : requestMap.entrySet()) {
            DiffViewer newViewer;
            final String key = entry.getKey();
            DiffRequest diffRequest = entry.getValue();
            diffRequest.getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), this);
            DiffViewer viewer = copy.remove(key);
            if (viewer != null && viewer.acceptsType(diffRequest.getType()) && viewer.canShowRequest(diffRequest)) {
                viewer.setDiffRequest(diffRequest);
                continue;
            }
            if (viewer != null) {
                this.removeTab(this.myUi.getContentManager().getContents(), key);
            }
            if ((newViewer = this.myRequest.viewerForRequest(this.myWindow, this.myParentDisposable, key, diffRequest)) == null) continue;
            this.myMap.put(key, newViewer);
            final Content content = this.myUi.createContent(key, newViewer.getComponent(), key, null, newViewer.getPreferredFocusedComponent());
            content.setCloseable(false);
            content.setPinned(true);
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    CompositeDiffPanel.this.myMap.remove(key);
                    CompositeDiffPanel.this.myUi.removeContent(content, true);
                }
            });
            this.myUi.addContent(content);
        }
        Content[] contents = this.myUi.getContentManager().getContents();
        for (String s : copy.keySet()) {
            this.removeTab(contents, s);
        }
        if (this.myMap.isEmpty()) {
            ErrorDiffViewer errorDiffViewer = new ErrorDiffViewer(request);
            this.myMap.put(FICTIVE_KEY, errorDiffViewer);
            Content content = this.myUi.createContent(FICTIVE_KEY, errorDiffViewer.getComponent(), FICTIVE_KEY, null, errorDiffViewer.getPreferredFocusedComponent());
            content.setCloseable(false);
            content.setPinned(true);
            content.setDisposer(this.myParentDisposable);
            this.myUi.addContent(content);
        }
    }

    private void removeTab(Content[] contents, String s) {
        this.myMap.remove(s);
        for (Content content : contents) {
            if (!s.equals(content.getDisplayName())) continue;
            this.myUi.getContentManager().removeContent(content, false);
            break;
        }
    }

    public JComponent getComponent() {
        return this.myUi.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Content[] contents = this.myUi.getContents();
        if (contents == null || contents.length == 0) {
            return null;
        }
        return contents[0].getPreferredFocusableComponent();
    }

    public int getContentsNumber() {
        return 101;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.multiLayer.equals((Object)type) || DiffViewerType.contents.equals((Object)type) || DiffViewerType.merge.equals((Object)type);
    }
}

