/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.actions.BaseDiffAction;
import com.intellij.openapi.diff.actions.ClipboardVsValueContents;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelection
extends BaseDiffAction {
    @Override
    @Nullable
    protected DiffRequest getDiffData(DataContext dataContext) {
        Editor editor;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editorData = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Editor editor2 = editor = editorData != null ? editorData : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        return new ClipboardSelectionContents(editor, project);
    }

    private static class ClipboardSelectionContents
    extends DiffRequest {
        private DiffContent[] myContents = null;
        private final Editor myEditor;

        public ClipboardSelectionContents(Editor editor, Project project) {
            super(project);
            this.myEditor = editor;
        }

        public String[] getContentTitles() {
            return new String[]{DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]), BaseDiffAction.isEditorContent(this.getDocument()) ? DiffBundle.message((String)"diff.content.selection.from.editor.content.title", (Object[])new Object[0]) : DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{BaseDiffAction.getDocumentFileUrl(this.getDocument())})};
        }

        public boolean isSafeToCallFromUpdate() {
            return !SystemInfo.isMac;
        }

        @NotNull
        public DiffContent[] getContents() {
            if (this.myContents != null) {
                if (this.myContents == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/CompareClipboardWithSelection$ClipboardSelectionContents", "getContents"));
                }
                return this.myContents;
            }
            DiffContent clipboardContent = ClipboardVsValueContents.createClipboardContent();
            if (clipboardContent == null) {
                clipboardContent = new SimpleContent("");
            }
            this.myContents = new DiffContent[2];
            this.myContents[0] = clipboardContent;
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                TextRange range = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                this.myContents[1] = new FragmentContent((DiffContent)DiffContent.fromDocument((Project)this.getProject(), (Document)this.getDocument()), range, this.getProject(), BaseDiffAction.getDocumentFile(this.getDocument()));
            } else {
                this.myContents[1] = DiffContent.fromDocument((Project)this.getProject(), (Document)this.getDocument());
            }
            if (this.myContents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/CompareClipboardWithSelection$ClipboardSelectionContents", "getContents"));
            }
            return this.myContents;
        }

        private Document getDocument() {
            return this.myEditor.getDocument();
        }

        public String getWindowTitle() {
            if (BaseDiffAction.isEditorContent(this.getDocument())) {
                return DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.clipboard.vs.file.dialog.title", (Object[])new Object[]{BaseDiffAction.getDocumentFileUrl(this.getDocument())});
        }
    }
}

