/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.StorageData");
    @NonNls
    public static final String COMPONENT = "component";
    @NonNls
    public static final String NAME = "name";
    final Map<String, Element> myComponentStates;
    protected final String myRootElementName;
    private int myHash = -1;

    public StorageData(String rootElementName) {
        this.myComponentStates = new THashMap();
        this.myRootElementName = rootElementName;
    }

    StorageData(StorageData storageData) {
        this.myRootElementName = storageData.myRootElementName;
        this.myComponentStates = new THashMap(storageData.myComponentStates);
    }

    public void load(@NotNull Element rootElement) throws IOException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageData", "load"));
        }
        Iterator iterator = rootElement.getChildren(COMPONENT).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String name = element.getAttributeValue(NAME);
            if (name == null) {
                LOG.info("Broken content in file : " + this);
                continue;
            }
            iterator.remove();
            if (element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            assert (element.getAttributeValue(NAME) != null) : "No name attribute for component: " + name + " in " + this;
            Element existingElement = this.myComponentStates.get(name);
            if (existingElement != null) {
                element = StorageData.mergeElements(name, element, existingElement);
            }
            this.myComponentStates.put(name, element);
        }
    }

    private static Element mergeElements(String name, Element element1, Element element2) {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.componentConfigurationMerger");
        for (XmlConfigurationMerger merger : (XmlConfigurationMerger[])point.getExtensions()) {
            if (!merger.getComponentName().equals(name)) continue;
            return merger.merge(element1, element2);
        }
        return element1;
    }

    @NotNull
    protected Element save() {
        Element rootElement = new Element(this.myRootElementName);
        Object[] componentNames = ArrayUtil.toStringArray(this.myComponentStates.keySet());
        Arrays.sort(componentNames);
        for (Object componentName : componentNames) {
            assert (componentName != null);
            Element element = this.myComponentStates.get(componentName);
            if (element.getAttribute(NAME) == null) {
                element.setAttribute(NAME, (String)componentName);
            }
            rootElement.addContent(element.clone());
        }
        Element element = rootElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "save"));
        }
        return element;
    }

    @Nullable
    public Element getState(String name) {
        Element element = this.myComponentStates.get(name);
        if (element != null) {
            assert (element.getAttributeValue(NAME) != null) : "No name attribute for component: " + name + " in " + this;
            element.removeAttribute(NAME);
        }
        return element;
    }

    void removeState(String componentName) {
        this.myComponentStates.remove(componentName);
        this.clearHash();
    }

    void setState(@NotNull String componentName, Element element) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/StorageData", "setState"));
        }
        element.setName(COMPONENT);
        ArrayList attributes = new ArrayList(element.getAttributes());
        for (Attribute attribute : attributes) {
            element.removeAttribute(attribute);
        }
        element.setAttribute(NAME, componentName);
        for (Attribute attribute : attributes) {
            element.setAttribute(attribute.getName(), attribute.getValue());
        }
        this.myComponentStates.put(componentName, element);
        this.clearHash();
    }

    public StorageData clone() {
        return new StorageData(this);
    }

    public final int getHash() {
        if (this.myHash == -1) {
            this.myHash = this.computeHash();
            if (this.myHash == -1) {
                this.myHash = 0;
            }
        }
        return this.myHash;
    }

    protected int computeHash() {
        int result = 0;
        for (String name : this.myComponentStates.keySet()) {
            result = 31 * result + name.hashCode();
            result = 31 * result + JDOMUtil.getTreeHash((Element)this.myComponentStates.get(name));
        }
        return result;
    }

    protected void clearHash() {
        this.myHash = -1;
    }

    public Set<String> getDifference(StorageData storageData, PathMacroSubstitutor substitutor) {
        THashSet bothStates = new THashSet(this.myComponentStates.keySet());
        bothStates.retainAll(storageData.myComponentStates.keySet());
        THashSet diffs = new THashSet();
        diffs.addAll(storageData.myComponentStates.keySet());
        diffs.addAll(this.myComponentStates.keySet());
        diffs.removeAll((Collection<?>)bothStates);
        for (String componentName : bothStates) {
            Element e1 = this.myComponentStates.get(componentName);
            Element e2 = storageData.myComponentStates.get(componentName);
            if (substitutor != null) {
                substitutor.expandPaths(e2);
            }
            if (JDOMUtil.areElementsEqual((Element)e1, (Element)e2)) continue;
            diffs.add(componentName);
        }
        return diffs;
    }

    public boolean isEmpty() {
        return this.myComponentStates.isEmpty();
    }

    public boolean hasState(String componentName) {
        return this.myComponentStates.containsKey(componentName);
    }

    public void checkUnknownMacros(TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        if (pathMacroSubstitutor == null) {
            return;
        }
        for (String componentName : this.myComponentStates.keySet()) {
            Set<String> unknownMacros = PathMacrosCollector.getMacroNames(this.myComponentStates.get(componentName));
            if (unknownMacros.isEmpty()) continue;
            pathMacroSubstitutor.addUnknownMacros(componentName, unknownMacros);
        }
    }
}

