/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageAnnotationsDefaultValues;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.ProjectStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ProjectStoreImpl
extends BaseFileConfigurableStoreImpl
implements IProjectStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.ProjectStoreImpl");
    @NonNls
    private static final String OLD_PROJECT_SUFFIX = "_old.";
    @NonNls
    static final String OPTION_WORKSPACE = "workspace";
    @NonNls
    static final String DEFAULT_STATE_STORAGE = "$PROJECT_FILE$";
    static final Storage DEFAULT_STORAGE_ANNOTATION = new MyStorage();
    private static int originalVersion = -1;
    protected ProjectImpl myProject;
    private StorageScheme myScheme = StorageScheme.DEFAULT;
    private String myCachedLocation;
    private String myPresentableUrl;
    private final StateStorageChooser<PersistentStateComponent<?>> myStateStorageChooser = new StateStorageChooser<PersistentStateComponent<?>>(){

        public Storage[] selectStorages(Storage[] storages, PersistentStateComponent<?> component, StateStorageOperation operation) {
            if (operation == StateStorageOperation.READ) {
                OrderedSet result = new OrderedSet();
                for (Storage storage : storages) {
                    if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                    result.add(0, (Object)storage);
                }
                for (Storage storage : storages) {
                    if (storage.scheme() != StorageScheme.DEFAULT) continue;
                    result.add((Object)storage);
                }
                return (Storage[])result.toArray((Object[])new Storage[result.size()]);
            }
            if (operation == StateStorageOperation.WRITE) {
                ArrayList<Storage> result = new ArrayList<Storage>();
                for (Storage storage : storages) {
                    if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                    result.add(storage);
                }
                if (!result.isEmpty()) {
                    return result.toArray(new Storage[result.size()]);
                }
                for (Storage storage : storages) {
                    if (storage.scheme() != StorageScheme.DEFAULT) continue;
                    result.add(storage);
                }
                return result.toArray(new Storage[result.size()]);
            }
            return new Storage[0];
        }
    };

    ProjectStoreImpl(ProjectImpl project) {
        super(project);
        this.myProject = project;
    }

    @Override
    public boolean checkVersion() {
        String message;
        ApplicationNamesInfo appNamesInfo = ApplicationNamesInfo.getInstance();
        if (originalVersion >= 0 && originalVersion < 4) {
            final VirtualFile projectFile = this.getProjectFile();
            LOG.assertTrue(projectFile != null);
            String name = projectFile.getNameWithoutExtension();
            String message2 = ProjectBundle.message((String)"project.convert.old.prompt", (Object[])new Object[]{projectFile.getName(), appNamesInfo.getProductName(), name + OLD_PROJECT_SUFFIX + projectFile.getExtension()});
            if (Messages.showYesNoDialog((String)message2, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            ArrayList<String> conversionProblems = ProjectStoreImpl.getConversionProblemsStorage();
            if (conversionProblems != null && !conversionProblems.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(ProjectBundle.message((String)"project.convert.problems.detected", (Object[])new Object[0]));
                for (String s : conversionProblems) {
                    buffer.append('\n');
                    buffer.append(s);
                }
                buffer.append(ProjectBundle.message((String)"project.convert.problems.help", (Object[])new Object[0]));
                int result = Messages.showOkCancelDialog((Project)this.myProject, (String)buffer.toString(), (String)ProjectBundle.message((String)"project.convert.problems.title", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.convert.problems.help.button", (Object[])new Object[0]), (String)CommonBundle.getCloseButtonText(), (Icon)Messages.getWarningIcon());
                if (result == 0) {
                    HelpManager.getInstance().invokeHelp("project.migrationProblems");
                }
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        VirtualFile projectDir = projectFile.getParent();
                        assert (projectDir != null);
                        this.backup(projectDir, projectFile);
                        VirtualFile workspaceFile = ProjectStoreImpl.this.getWorkspaceFile();
                        if (workspaceFile != null) {
                            this.backup(projectDir, workspaceFile);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private void backup(VirtualFile projectDir, VirtualFile vile) throws IOException {
                    String oldName = vile.getNameWithoutExtension() + ProjectStoreImpl.OLD_PROJECT_SUFFIX + vile.getExtension();
                    VirtualFile oldFile = projectDir.findOrCreateChildData((Object)this, oldName);
                    assert (oldFile != null) : projectDir + ", " + oldName;
                    VfsUtil.saveText((VirtualFile)oldFile, (String)VfsUtilCore.loadText((VirtualFile)vile));
                }
            });
        }
        return originalVersion <= 4 || Messages.showYesNoDialog((String)(message = ProjectBundle.message((String)"project.load.new.version.warning", (Object[])new Object[]{this.myProject.getName(), appNamesInfo.getProductName()})), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        return new TrackingPathMacroSubstitutor[]{this.getStateStorageManager().getMacroSubstitutor()};
    }

    @Override
    protected boolean optimizeTestLoading() {
        return this.myProject.isOptimiseTestLoadSpeed();
    }

    @Override
    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public void setProjectFilePath(final @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "setProjectFilePath"));
        }
        StateStorageManager stateStorageManager = this.getStateStorageManager();
        final LocalFileSystem fs = LocalFileSystem.getInstance();
        File file = new File(filePath);
        if (!ProjectStoreImpl.isIprPath(file)) {
            this.myScheme = StorageScheme.DIRECTORY_BASED;
            final File dirStore = file.isDirectory() ? new File(file, ".idea") : new File(file.getParentFile(), ".idea");
            stateStorageManager.addMacro(StoragePathMacros.getMacroName((String)DEFAULT_STATE_STORAGE), new File(dirStore, "misc.xml").getPath());
            File ws = new File(dirStore, "workspace.xml");
            stateStorageManager.addMacro(StoragePathMacros.getMacroName((String)"$WORKSPACE_FILE$"), ws.getPath());
            if (!ws.exists() && !file.isDirectory()) {
                ProjectStoreImpl.useOldWsContent(filePath, ws);
            }
            stateStorageManager.addMacro(StoragePathMacros.getMacroName((String)"$PROJECT_CONFIG_DIR$"), dirStore.getPath());
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByIoFile(dirStore)});
                }
            }, ModalityState.defaultModalityState());
        } else {
            this.myScheme = StorageScheme.DEFAULT;
            stateStorageManager.addMacro(StoragePathMacros.getMacroName((String)DEFAULT_STATE_STORAGE), filePath);
            final String workspacePath = ProjectStoreImpl.composeWsPath(filePath);
            stateStorageManager.addMacro(StoragePathMacros.getMacroName((String)"$WORKSPACE_FILE$"), workspacePath);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByPath(filePath), fs.refreshAndFindFileByPath(workspacePath)});
                }
            }, ModalityState.defaultModalityState());
        }
        this.myCachedLocation = null;
        this.myPresentableUrl = null;
    }

    private static boolean isIprPath(File file) {
        return FileUtilRt.extensionEquals((String)file.getName(), (String)"ipr");
    }

    private static String composeWsPath(String filePath) {
        int lastDot = filePath.lastIndexOf(".");
        String filePathWithoutExt = lastDot > 0 ? filePath.substring(0, lastDot) : filePath;
        return filePathWithoutExt + ".iws";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useOldWsContent(String filePath, File ws) {
        File oldWs = new File(ProjectStoreImpl.composeWsPath(filePath));
        if (oldWs.exists()) {
            try {
                FileInputStream is = new FileInputStream(oldWs);
                try {
                    byte[] bytes = FileUtil.loadBytes((InputStream)is, (int)((int)oldWs.length()));
                    FileOutputStream os = new FileOutputStream(ws);
                    try {
                        ((OutputStream)os).write(bytes);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public VirtualFile getProjectBaseDir() {
        if (this.myProject.isDefault()) {
            return null;
        }
        String path = this.getProjectBasePath();
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public String getProjectBasePath() {
        if (this.myProject.isDefault()) {
            return null;
        }
        String path = this.getProjectFilePath();
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            return this.myScheme == StorageScheme.DEFAULT ? new File(path).getParent() : new File(path).getParentFile().getParent();
        }
        StateStorage s = this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        if (!(s instanceof FileBasedStorage)) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)s;
        File file = storage.getFile();
        if (file == null) {
            return null;
        }
        return this.myScheme == StorageScheme.DEFAULT ? file.getParent() : file.getParentFile().getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        if (this.myScheme == StorageScheme.DIRECTORY_BASED) {
            VirtualFile baseDir;
            block14: {
                VirtualFile nameFile;
                baseDir = this.getProjectBaseDir();
                assert (baseDir != null) : "scheme=" + this.myScheme + " project file=" + this.getProjectFilePath();
                VirtualFile ideaDir = baseDir.findChild(".idea");
                if (ideaDir != null && ideaDir.isValid() && (nameFile = ideaDir.findChild(".name")) != null && nameFile.isValid()) {
                    BufferedReader in;
                    block13: {
                        in = new BufferedReader(new InputStreamReader(nameFile.getInputStream(), "UTF-8"));
                        String name = in.readLine();
                        if (name == null || name.length() <= 0) break block13;
                        String string = name.trim();
                        in.close();
                        String string2 = string;
                        if (string2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
                        }
                        return string2;
                    }
                    try {
                        in.close();
                        break block14;
                        {
                            catch (Throwable throwable) {
                                in.close();
                                throw throwable;
                            }
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
            String string = baseDir.getName().replace(":", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
            }
            return string;
        }
        String temp = this.getProjectFileName();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(temp);
        if (fileType instanceof ProjectFileType) {
            temp = temp.substring(0, temp.length() - fileType.getDefaultExtension().length() - 1);
        }
        if ((i = temp.lastIndexOf(File.separatorChar)) >= 0) {
            temp = temp.substring(i + 1, temp.length() - i + 1);
        }
        String string = temp;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
        }
        return string;
    }

    @NotNull
    private String getProjectFileName() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        String string = storage.getFileName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myScheme;
        if (storageScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getStorageScheme"));
        }
        return storageScheme;
    }

    @Override
    public String getPresentableUrl() {
        if (this.myProject.isDefault()) {
            return null;
        }
        if (this.myPresentableUrl == null) {
            String url;
            String string = url = this.myScheme == StorageScheme.DIRECTORY_BASED ? this.getProjectBasePath() : this.getProjectFilePath();
            if (url != null) {
                this.myPresentableUrl = FileUtil.toSystemDependentName((String)url);
            }
        }
        return this.myPresentableUrl;
    }

    @Override
    public void loadProject() throws IOException, JDOMException, InvalidDataException, StateStorageException {
        this.myProject.init();
    }

    @Override
    public VirtualFile getProjectFile() {
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    public VirtualFile getWorkspaceFile() {
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage("$WORKSPACE_FILE$");
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    public void loadProjectFromTemplate(@NotNull ProjectImpl defaultProject) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "loadProjectFromTemplate"));
        }
        StateStorage stateStorage = this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (stateStorage instanceof XmlElementStorage);
        XmlElementStorage xmlElementStorage = (XmlElementStorage)stateStorage;
        defaultProject.save();
        IProjectStore projectStore = defaultProject.getStateStore();
        assert (projectStore instanceof DefaultProjectStoreImpl);
        DefaultProjectStoreImpl defaultProjectStore = (DefaultProjectStoreImpl)projectStore;
        Element element = defaultProjectStore.getStateCopy();
        if (element != null) {
            xmlElementStorage.setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        if (this.myProject.isDefault()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectFilePath"));
            }
            return "";
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        String string = storage.getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectFilePath"));
        }
        return string;
    }

    @Override
    protected XmlElementStorage getMainStorage() {
        XmlElementStorage storage = (XmlElementStorage)this.getStateStorageManager().getFileStateStorage(DEFAULT_STATE_STORAGE);
        assert (storage != null);
        return storage;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ProjectStateStorageManager projectStateStorageManager = new ProjectStateStorageManager(PathMacroManager.getInstance(this.getComponentManager()).createTrackingSubstitutor(), this.myProject);
        if (projectStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "createStateStorageManager"));
        }
        return projectStateStorageManager;
    }

    @Override
    protected ComponentStoreImpl.SaveSessionImpl createSaveSession() throws StateStorageException {
        return new ProjectSaveSession();
    }

    @Override
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return this.myStateStorageChooser;
    }

    @Override
    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorageException {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        Storage[] result = super.getComponentStorageSpecs(persistentStateComponent, operation);
        if (operation == StateStorageOperation.READ) {
            Storage[] upd = new Storage[result.length + 1];
            System.arraycopy(result, 0, upd, 0, result.length);
            upd[result.length] = DEFAULT_STORAGE_ANNOTATION;
            result = upd;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload(@NotNull Set<Pair<VirtualFile, StateStorage>> changedFiles) throws IOException, StateStorageException {
        Set<String> componentNames;
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "reload"));
        }
        IComponentStore.SaveSession saveSession = this.startSave();
        try {
            componentNames = saveSession.analyzeExternalChanges(changedFiles);
            if (componentNames == null) {
                boolean bl = false;
                return bl;
            }
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                if (pair.second != null) continue;
                boolean bl = false;
                return bl;
            }
            StorageUtil.logStateDiffInfo(changedFiles, componentNames);
            if (!this.isReloadPossible(componentNames)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.finishSave(saveSession);
        }
        if (!componentNames.isEmpty()) {
            ((BatchUpdateListener)this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
            try {
                this.doReload(changedFiles, componentNames);
                this.reinitComponents(componentNames, false);
            }
            finally {
                ((BatchUpdateListener)this.myProject.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
            }
        }
        return true;
    }

    private static class MyStorage
    implements Storage {
        private MyStorage() {
        }

        public String id() {
            return "___Default___";
        }

        public boolean isDefault() {
            return true;
        }

        public String file() {
            return ProjectStoreImpl.DEFAULT_STATE_STORAGE;
        }

        public StorageScheme scheme() {
            return StorageScheme.DEFAULT;
        }

        public Class<? extends StateStorage> storageClass() {
            return StorageAnnotationsDefaultValues.NullStateStorage.class;
        }

        public Class<? extends StateSplitter> stateSplitter() {
            return StorageAnnotationsDefaultValues.NullStateSplitter.class;
        }

        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("Method annotationType not implemented in " + this.getClass());
        }
    }

    protected class ProjectSaveSession
    extends ComponentStoreImpl.SaveSessionImpl {
        ProjectSaveSession() throws StateStorageException {
        }

        @Override
        @NotNull
        public List<IFile> getAllStorageFilesToSave(boolean includingSubStructures) throws IOException {
            ArrayList<IFile> result = new ArrayList<IFile>();
            if (includingSubStructures) {
                this.collectSubfilesToSave(result);
            }
            result.addAll(super.getAllStorageFilesToSave(false));
            ArrayList<IFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$ProjectSaveSession", "getAllStorageFilesToSave"));
            }
            return arrayList;
        }

        protected void collectSubfilesToSave(List<IFile> result) throws IOException {
        }

        @Override
        @NotNull
        public IComponentStore.SaveSession save() throws IOException {
            ProjectImpl.UnableToSaveProjectNotification[] notifications = (ProjectImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectImpl.UnableToSaveProjectNotification.class, (Project)ProjectStoreImpl.this.myProject);
            if (notifications.length > 0) {
                throw new IComponentStore.SaveCancelledException();
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = this.ensureConfigFilesWritable();
            if (operationStatus == null) {
                throw new IOException();
            }
            if (operationStatus.hasReadonlyFiles()) {
                ProjectImpl.dropUnableToSaveProjectNotification(ProjectStoreImpl.this.myProject, operationStatus.getReadonlyFiles());
                throw new IComponentStore.SaveCancelledException();
            }
            this.beforeSave();
            super.save();
            ProjectSaveSession projectSaveSession = this;
            if (projectSaveSession == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$ProjectSaveSession", "save"));
            }
            return projectSaveSession;
        }

        protected void beforeSave() throws IOException {
        }

        private ReadonlyStatusHandler.OperationStatus ensureConfigFilesWritable() {
            return (ReadonlyStatusHandler.OperationStatus)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ReadonlyStatusHandler.OperationStatus>(){

                public ReadonlyStatusHandler.OperationStatus compute() {
                    VirtualFile projectBaseDir;
                    VirtualFile baseDir;
                    List<IFile> filesToSave;
                    try {
                        filesToSave = ProjectSaveSession.this.getAllStorageFilesToSave(true);
                        Iterator<IFile> iterator = filesToSave.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next().exists()) continue;
                            iterator.remove();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                    ArrayList<VirtualFile> readonlyFiles = new ArrayList<VirtualFile>();
                    if (ProjectStoreImpl.this.myProject.isToSaveProjectName() && (baseDir = ProjectStoreImpl.this.getProjectBaseDir()) != null && baseDir.isValid()) {
                        filesToSave.add(FileSystem.FILE_SYSTEM.createFile(new File(new File(baseDir.getPath(), ".idea"), ".name").getPath()));
                    }
                    for (IFile file : filesToSave) {
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                        if (virtualFile == null) continue;
                        virtualFile.refresh(false, false);
                        if (!virtualFile.isValid() || virtualFile.isWritable()) continue;
                        readonlyFiles.add(virtualFile);
                    }
                    if (readonlyFiles.size() == 0 && (projectBaseDir = ProjectStoreImpl.this.getProjectBaseDir()) != null && projectBaseDir.isValid()) {
                        LocalFileSystem instance;
                        VirtualFile ideaDir1;
                        if (!projectBaseDir.isWritable()) {
                            readonlyFiles.add(projectBaseDir);
                        }
                        if ((ideaDir1 = (instance = LocalFileSystem.getInstance()).findFileByIoFile(new File(projectBaseDir.getPath(), ".idea"))) != null && ideaDir1.isValid()) {
                            if (!ideaDir1.isWritable()) {
                                readonlyFiles.add(ideaDir1);
                            }
                        } else {
                            VirtualFile ideaDir2 = instance.findFileByIoFile(new File(new File(projectBaseDir.getPath()).getParent(), ".idea"));
                            if (ideaDir2 != null && ideaDir2.isValid() && !ideaDir2.isWritable()) {
                                readonlyFiles.add(ideaDir2);
                            }
                        }
                    }
                    return ReadonlyStatusHandler.getInstance((Project)ProjectStoreImpl.this.myProject).ensureFilesWritable(readonlyFiles);
                }
            });
        }
    }

    static class IprStorageData
    extends ProjectStorageData {
        IprStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        IprStorageData(IprStorageData storageData) {
            super(storageData);
        }

        @Override
        public void load(@NotNull Element root) throws IOException {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$IprStorageData", "load"));
            }
            String v = root.getAttributeValue("version");
            originalVersion = v != null ? Integer.parseInt(v) : 0;
            if (originalVersion != 4) {
                this.convert(root, originalVersion);
            }
            super.load(root);
        }

        protected void convert(Element root, int originalVersion) {
        }

        @Override
        public StorageData clone() {
            return new IprStorageData(this);
        }
    }

    static class WsStorageData
    extends ProjectStorageData {
        WsStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        WsStorageData(WsStorageData storageData) {
            super(storageData);
        }

        @Override
        public StorageData clone() {
            return new WsStorageData(this);
        }
    }

    static class ProjectStorageData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        protected final Project myProject;

        ProjectStorageData(String rootElementName, Project project) {
            super(rootElementName);
            this.myProject = project;
        }

        protected ProjectStorageData(ProjectStorageData storageData) {
            super(storageData);
            this.myProject = storageData.myProject;
        }

        @Override
        public StorageData clone() {
            return new ProjectStorageData(this);
        }
    }
}

