/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class ModuleStateStorageManager
extends StateStorageManagerImpl {
    @NonNls
    private static final String ROOT_TAG_NAME = "module";
    private final Module myModule;

    public ModuleStateStorageManager(@Nullable TrackingPathMacroSubstitutor pathMacroManager, Module module) {
        super(pathMacroManager, ROOT_TAG_NAME, (Disposable)module, module.getPicoContainer());
        this.myModule = module;
    }

    @Override
    protected StorageData createStorageData(String storageSpec) {
        return new ModuleStoreImpl.ModuleFileData(ROOT_TAG_NAME, this.myModule);
    }

    @Override
    protected String getOldStorageSpec(Object component, String componentName, StateStorageOperation operation) {
        return "$MODULE_FILE$";
    }

    @Override
    protected String getVersionsFilePath() {
        return PathManager.getConfigPath() + "/componentVersions/" + ROOT_TAG_NAME + this.getLocationHash() + ".xml";
    }

    private String getLocationHash() {
        return this.myModule.getName() + Integer.toHexString(this.myModule.getModuleFilePath().hashCode());
    }
}

