/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryStorageData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DirectoryStorageData");
    private Map<String, Map<IFile, Element>> myStates = new HashMap<String, Map<IFile, Element>>();
    private long myLastTimestamp = 0L;
    private DirectoryStorageData myOriginalData;

    public Set<String> getComponentNames() {
        return this.myStates.keySet();
    }

    public void loadFrom(@Nullable VirtualFile dir, TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            return;
        }
        for (VirtualFile file : dir.getChildren()) {
            if (!StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".xml")) continue;
            try {
                Document document = JDOMUtil.loadDocument((byte[])file.contentsToByteArray());
                Element element = document.getRootElement();
                if (!element.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element.getName() + ") in " + file.getPresentableUrl());
                    continue;
                }
                String componentName = element.getAttributeValue("name");
                if (componentName == null) {
                    LOG.error("Component name isn't specified in " + file.getPresentableUrl());
                    continue;
                }
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(element);
                    Set<String> unknownMacros = PathMacrosCollector.getMacroNames(element);
                    pathMacroSubstitutor.addUnknownMacros(componentName, unknownMacros);
                }
                this.put(componentName, FileSystem.FILE_SYSTEM.createFile(file.getPath()), element, true);
            }
            catch (IOException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
            catch (JDOMException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
        }
    }

    public void put(String componentName, IFile file, Element element, boolean updateTimestamp) {
        LOG.assertTrue(componentName != null, (Object)String.format("Component name should not be null for file: %s", file == null ? "NULL!" : file.getPath()));
        Map<IFile, Element> stateMap = this.myStates.get(componentName);
        if (stateMap == null) {
            stateMap = new HashMap<IFile, Element>();
            this.myStates.put(componentName, stateMap);
        }
        stateMap.put(file, element);
        if (updateTimestamp) {
            this.updateLastTimestamp(file);
        }
    }

    public void updateLastTimestamp(IFile file) {
        this.myLastTimestamp = Math.max(this.myLastTimestamp, file.getTimeStamp());
        if (this.myOriginalData != null) {
            this.myOriginalData.myLastTimestamp = this.myLastTimestamp;
        }
    }

    public long getLastTimeStamp() {
        return this.myLastTimestamp;
    }

    public Map<IFile, Long> getAllStorageFiles() {
        THashMap allStorageFiles = new THashMap();
        this.process(new StorageDataProcessor((Map)allStorageFiles){
            final /* synthetic */ Map val$allStorageFiles;
            {
                this.val$allStorageFiles = map;
            }

            @Override
            public void process(String componentName, IFile file, Element element) {
                this.val$allStorageFiles.put(file, file.getTimeStamp());
            }
        });
        return allStorageFiles;
    }

    public void processComponent(@NotNull String componentName, @NotNull PairConsumer<IFile, Element> consumer) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        Map<IFile, Element> map = this.myStates.get(componentName);
        if (map != null) {
            for (IFile file : map.keySet()) {
                consumer.consume((Object)file, (Object)map.get(file));
            }
        }
    }

    public void process(final @NotNull StorageDataProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "process"));
        }
        for (final String componentName : this.myStates.keySet()) {
            this.processComponent(componentName, new PairConsumer<IFile, Element>(){

                public void consume(IFile iFile, Element element) {
                    processor.process(componentName, iFile, element);
                }
            });
        }
    }

    protected DirectoryStorageData clone() {
        DirectoryStorageData result = new DirectoryStorageData();
        result.myStates = new HashMap<String, Map<IFile, Element>>(this.myStates);
        result.myLastTimestamp = this.myLastTimestamp;
        result.myOriginalData = this;
        return result;
    }

    public void clear() {
        this.myStates.clear();
        this.myOriginalData = null;
    }

    public boolean containsComponent(String componentName) {
        return this.myStates.get(componentName) != null;
    }

    public void removeComponent(String componentName) {
        this.myStates.remove(componentName);
    }

    @Nullable
    public <T> T getMergedState(String componentName, Class<T> stateClass, StateSplitter splitter, @Nullable T mergeInto) {
        final ArrayList subElements = new ArrayList();
        this.processComponent(componentName, new PairConsumer<IFile, Element>(){

            public void consume(IFile iFile, Element element) {
                List children = element.getChildren();
                assert (children.size() == 1) : JDOMUtil.writeElement((Element)element, (String)File.separator);
                Element subElement = (Element)children.get(0);
                subElement.detach();
                subElements.add(subElement);
            }
        });
        Element state = new Element("component");
        splitter.mergeStatesInto(state, subElements.toArray(new Element[subElements.size()]));
        this.removeComponent(componentName);
        return DefaultStateSerializer.deserializeState(state, stateClass, mergeInto);
    }

    static interface StorageDataProcessor {
        public void process(String var1, IFile var2, Element var3);
    }
}

