/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.JDOMXIncluder;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultsStateStorage
implements StateStorage {
    private final PathMacroManager myPathMacroManager;

    public DefaultsStateStorage(@Nullable PathMacroManager pathMacroManager) {
        this.myPathMacroManager = pathMacroManager;
    }

    @Nullable
    public Element getState(Object component, String componentName) throws StateStorageException {
        URL url = DecodeDefaultsUtil.getDefaults(component, componentName);
        if (url == null) {
            return null;
        }
        try {
            Document document = JDOMUtil.loadDocument((URL)url);
            document = JDOMXIncluder.resolve((Document)document, (String)url.toExternalForm());
            Element documentElement = document.getRootElement();
            if (this.myPathMacroManager != null) {
                this.myPathMacroManager.expandPaths(documentElement);
            }
            return documentElement;
        }
        catch (IOException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
        catch (JDOMException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
    }

    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        return DefaultStateSerializer.deserializeState(this.getState(component, componentName), stateClass, mergeInto);
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorageException {
        URL url = DecodeDefaultsUtil.getDefaults(component, componentName);
        return url != null;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        throw new UnsupportedOperationException("Method startExternalization not implemented in " + this.getClass());
    }

    @NotNull
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "startSave"));
        }
        throw new UnsupportedOperationException("Method startSave not implemented in " + this.getClass());
    }

    public void finishSave(@NotNull StateStorage.SaveSession saveSession) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "finishSave"));
        }
        throw new UnsupportedOperationException("Method finishSave not implemented in " + this.getClass());
    }

    public void reload(@NotNull Set<String> changedComponents) throws StateStorageException {
        if (changedComponents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "reload"));
        }
        throw new UnsupportedOperationException("Method reload not implemented in " + this.getClass());
    }
}

