/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompoundExternalizationSession {
    private final Map<StateStorage, StateStorage.ExternalizationSession> mySessions = new THashMap(1);

    @NotNull
    public StateStorage.ExternalizationSession getExternalizationSession(@NotNull StateStorage stateStore) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/CompoundExternalizationSession", "getExternalizationSession"));
        }
        StateStorage.ExternalizationSession session = this.mySessions.get(stateStore);
        if (session == null) {
            session = stateStore.startExternalization();
            this.mySessions.put(stateStore, session);
        }
        StateStorage.ExternalizationSession externalizationSession = session;
        if (externalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/CompoundExternalizationSession", "getExternalizationSession"));
        }
        return externalizationSession;
    }

    @NotNull
    public Collection<StateStorage> getStateStorages() {
        Set<StateStorage> set = this.mySessions.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/CompoundExternalizationSession", "getStateStorages"));
        }
        return set;
    }
}

