/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultsStateStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseFileConfigurableStoreImpl
extends ComponentStoreImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl");
    @NonNls
    protected static final String VERSION_OPTION = "version";
    @NonNls
    public static final String ATTRIBUTE_NAME = "name";
    private final ComponentManager myComponentManager;
    private static final ArrayList<String> ourConversionProblemsStorage = new ArrayList();
    private final DefaultsStateStorage myDefaultsStateStorage;
    private StateStorageManager myStateStorageManager;

    protected BaseFileConfigurableStoreImpl(ComponentManager componentManager) {
        this.myComponentManager = componentManager;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance(this.myComponentManager);
        this.myDefaultsStateStorage = new DefaultsStateStorage(pathMacroManager);
    }

    public synchronized ComponentManager getComponentManager() {
        return this.myComponentManager;
    }

    protected abstract XmlElementStorage getMainStorage();

    @Nullable
    static ArrayList<String> getConversionProblemsStorage() {
        return ourConversionProblemsStorage;
    }

    @Override
    public void load() throws IOException, StateStorageException {
        this.getMainStorageData();
    }

    public BaseStorageData getMainStorageData() throws StateStorageException {
        return (BaseStorageData)this.getMainStorage().getStorageData(false);
    }

    @Override
    protected StateStorage getDefaultsStorage() {
        return this.myDefaultsStateStorage;
    }

    @Override
    @NotNull
    public StateStorageManager getStateStorageManager() {
        if (this.myStateStorageManager == null) {
            this.myStateStorageManager = this.createStateStorageManager();
        }
        StateStorageManager stateStorageManager = this.myStateStorageManager;
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "getStateStorageManager"));
        }
        return stateStorageManager;
    }

    @NotNull
    protected abstract StateStorageManager createStateStorageManager();

    protected static class BaseStorageData
    extends FileBasedStorage.FileStorageData {
        protected int myVersion;

        public BaseStorageData(String rootElementName) {
            super(rootElementName);
        }

        protected BaseStorageData(BaseStorageData storageData) {
            super(storageData);
            this.myVersion = 4;
        }

        @Override
        public void load(@NotNull Element rootElement) throws IOException {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "load"));
            }
            super.load(rootElement);
            String v = rootElement.getAttributeValue(BaseFileConfigurableStoreImpl.VERSION_OPTION);
            this.myVersion = v != null ? Integer.parseInt(v) : 4;
        }

        @Override
        @NotNull
        protected Element save() {
            Element root = super.save();
            root.setAttribute(BaseFileConfigurableStoreImpl.VERSION_OPTION, Integer.toString(this.myVersion));
            Element element = root;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "save"));
            }
            return element;
        }

        @Override
        public StorageData clone() {
            return new BaseStorageData(this);
        }

        @Override
        protected int computeHash() {
            int result = super.computeHash();
            result = result * 31 + this.myVersion;
            return result;
        }

        @Override
        @Nullable
        public Set<String> getDifference(StorageData storageData, PathMacroSubstitutor substitutor) {
            BaseStorageData data = (BaseStorageData)storageData;
            if (this.myVersion != data.myVersion) {
                return null;
            }
            return super.getDifference(storageData, substitutor);
        }
    }
}

