/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.ComponentManagerConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.IdeaPicoContainer;
import gnu.trove.THashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManagerEx,
org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.components.ComponentManager");
    private final Map<Class, Object> myInitializedComponents;
    private boolean myComponentsCreated;
    private MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed;
    private volatile boolean myDisposeCompleted;
    private MessageBus myMessageBus;
    private final ComponentManagerConfigurator myConfigurator;
    private final ComponentManager myParentComponentManager;
    private Boolean myHeadless;
    private ComponentsRegistry myComponentsRegistry;
    private final Condition myDisposedCondition;
    protected volatile boolean temporarilyDisposed;

    protected ComponentManagerImpl(ComponentManager parentComponentManager) {
        this.myInitializedComponents = new ConcurrentHashMap();
        this.myComponentsCreated = false;
        this.myDisposed = false;
        this.myDisposeCompleted = false;
        this.myConfigurator = new ComponentManagerConfigurator(this);
        this.myComponentsRegistry = new ComponentsRegistry();
        this.myDisposedCondition = new Condition(){

            public boolean value(Object o) {
                return ComponentManagerImpl.this.isDisposed();
            }
        };
        this.temporarilyDisposed = false;
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(this.toString());
    }

    protected ComponentManagerImpl(ComponentManager parentComponentManager, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/components/impl/ComponentManagerImpl", "<init>"));
        }
        this.myInitializedComponents = new ConcurrentHashMap();
        this.myComponentsCreated = false;
        this.myDisposed = false;
        this.myDisposeCompleted = false;
        this.myConfigurator = new ComponentManagerConfigurator(this);
        this.myComponentsRegistry = new ComponentsRegistry();
        this.myDisposedCondition = new /* invalid duplicate definition of identical inner class */;
        this.temporarilyDisposed = false;
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(name);
    }

    public void init() {
        this.createComponents();
        this.getComponents();
    }

    @NotNull
    public MessageBus getMessageBus() {
        assert (!this.myDisposeCompleted && !this.myDisposed) : "Already disposed";
        assert (this.myMessageBus != null) : "Not initialized yet";
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getMessageBus"));
        }
        return messageBus;
    }

    public boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponents() {
        try {
            Class[] componentInterfaces;
            this.myComponentsRegistry.loadClasses();
            for (Class componentInterface : componentInterfaces = this.myComponentsRegistry.getComponentInterfaces()) {
                ProgressIndicatorProvider.checkCanceled();
                this.createComponent(componentInterface);
            }
        }
        finally {
            this.myComponentsCreated = true;
        }
    }

    protected synchronized Object createComponent(Class componentInterface) {
        Object component = this.getPicoContainer().getComponentInstance((Object)componentInterface.getName());
        LOG.assertTrue(component != null, (Object)("Can't instantiate component for: " + componentInterface));
        return component;
    }

    protected synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        List<Object> components = this.myComponentsRegistry.getRegisteredImplementations();
        this.myDisposed = true;
        for (int i = components.size() - 1; i >= 0; --i) {
            Object component = components.get(i);
            if (!(component instanceof BaseComponent)) continue;
            try {
                ((BaseComponent)component).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myComponentsCreated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T getComponentFromContainer(Class<T> interfaceClass) {
        Object initializedComponent = this.myInitializedComponents.get(interfaceClass);
        if (initializedComponent != null) {
            return (T)initializedComponent;
        }
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            Object lock;
            if (this.myComponentsRegistry == null || !this.myComponentsRegistry.containsInterface(interfaceClass)) {
                return null;
            }
            Object object = lock = this.myComponentsRegistry.getComponentLock(interfaceClass);
            synchronized (object) {
                Object dcl = this.myInitializedComponents.get(interfaceClass);
                if (dcl != null) {
                    return (T)dcl;
                }
                Object component = this.getPicoContainer().getComponentInstance((Object)interfaceClass.getName());
                if (component == null) {
                    component = this.createComponent(interfaceClass);
                }
                if (component == null) {
                    throw new IncorrectOperationException("createComponent() returns null for: " + interfaceClass);
                }
                this.myInitializedComponents.put(interfaceClass, component);
                if (component instanceof Disposable) {
                    Disposer.register((Disposable)this, (Disposable)((Disposable)component));
                }
                return (T)component;
            }
        }
    }

    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        assert (!this.myDisposeCompleted) : "Already disposed: " + this;
        return this.getComponent(interfaceClass, null);
    }

    public <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        T fromContainer = this.getComponentFromContainer(interfaceClass);
        if (fromContainer != null) {
            return fromContainer;
        }
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return null;
    }

    @Nullable
    protected static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    protected float getPercentageOfComponentsLoaded() {
        return this.myComponentsRegistry.getPercentageOfComponentsLoaded();
    }

    @Override
    public void initializeComponent(Object component, boolean service) {
    }

    protected void handleInitComponentError(Throwable ex, String componentClassName, ComponentConfig config) {
        LOG.error(ex);
    }

    @Override
    public synchronized void registerComponent(ComponentConfig config, PluginDescriptor pluginDescriptor) {
        if (!config.prepareClasses(this.isHeadless())) {
            return;
        }
        config.pluginDescriptor = pluginDescriptor;
        this.myComponentsRegistry.registerComponent(config);
    }

    public synchronized void registerComponentImplementation(Class componentKey, Class componentImplementation) {
        this.getPicoContainer().registerComponentImplementation((Object)componentKey.getName(), componentImplementation);
        this.myInitializedComponents.remove(componentKey);
    }

    public synchronized <T> T registerComponentInstance(Class<T> componentKey, T componentImplementation) {
        this.getPicoContainer().unregisterComponent((Object)componentKey.getName());
        this.getPicoContainer().registerComponentInstance((Object)componentKey.getName(), componentImplementation);
        Object t = this.myInitializedComponents.remove(componentKey);
        return (T)t;
    }

    public synchronized boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "hasComponent"));
        }
        return this.myComponentsRegistry != null && this.myComponentsRegistry.containsInterface(interfaceClass);
    }

    protected synchronized Object[] getComponents() {
        Class[] componentClasses = this.myComponentsRegistry.getComponentInterfaces();
        ArrayList components = new ArrayList(componentClasses.length);
        for (Class interfaceClass : componentClasses) {
            ProgressIndicatorProvider.checkCanceled();
            Object component = this.getComponent(interfaceClass);
            if (component == null) continue;
            components.add(component);
        }
        return ArrayUtil.toObjectArray(components);
    }

    @NotNull
    public synchronized <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponents"));
        }
        T[] TArray = this.myComponentsRegistry.getComponentsByType(baseClass);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponents"));
        }
        return TArray;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        assert (!this.myDisposeCompleted) : "Already disposed";
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getPicoContainer"));
        }
        return mutablePicoContainer;
    }

    protected MutablePicoContainer createPicoContainer() {
        IdeaPicoContainer result = this.myParentComponentManager != null ? new IdeaPicoContainer(this.myParentComponentManager.getPicoContainer()) : new IdeaPicoContainer();
        return result;
    }

    public synchronized BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        return this.myComponentsRegistry.getComponentByName(name);
    }

    protected boolean isComponentSuitable(Map<String, String> options) {
        return !ComponentManagerImpl.isTrue(options, "internal") || ApplicationManager.getApplication().isInternal();
    }

    private static boolean isTrue(Map<String, String> options, @NonNls String option) {
        return options != null && options.containsKey(option) && Boolean.valueOf(options.get(option)) != false;
    }

    public synchronized void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            this.myMessageBus.dispose();
            this.myMessageBus = null;
        }
        this.myInitializedComponents.clear();
        this.myComponentsRegistry = null;
        this.myPicoContainer = null;
    }

    public boolean isDisposed() {
        return this.myDisposed || this.temporarilyDisposed;
    }

    public void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    protected void loadComponentsConfiguration(ComponentConfig[] components, @Nullable PluginDescriptor descriptor, boolean defaultProject) {
        this.myConfigurator.loadComponentsConfiguration(components, descriptor, defaultProject);
    }

    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "bootstrapPicoContainer"));
        }
        this.myPicoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)name, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        MutablePicoContainer picoContainer = this.getPicoContainer();
        picoContainer.registerComponentInstance(MessageBus.class, (Object)this.myMessageBus);
    }

    protected ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    private boolean isHeadless() {
        if (this.myHeadless == null) {
            this.myHeadless = ApplicationManager.getApplication().isHeadlessEnvironment();
        }
        return this.myHeadless;
    }

    @Override
    public void registerComponent(ComponentConfig config) {
        this.registerComponent(config, null);
    }

    @NotNull
    public ComponentConfig[] getComponentConfigurations() {
        ComponentConfig[] componentConfigArray = this.myComponentsRegistry.getComponentConfigurations();
        if (componentConfigArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentConfigurations"));
        }
        return componentConfigArray;
    }

    @Nullable
    public Object getComponent(ComponentConfig componentConfig) {
        return this.getPicoContainer().getComponentInstance((Object)componentConfig.getInterfaceClass());
    }

    public ComponentConfig getConfig(Class componentImplementation) {
        return this.myComponentsRegistry.getConfig(componentImplementation);
    }

    @NotNull
    public Condition getDisposed() {
        Condition condition = this.myDisposedCondition;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getDisposed"));
        }
        return condition;
    }

    @NotNull
    public static String getComponentName(@NotNull Object component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
        }
        if (component instanceof NamedComponent) {
            String string = ((NamedComponent)component).getComponentName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
            }
            return string;
        }
        String string = component.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
        }
        return string;
    }

    protected boolean logSlowComponents() {
        return LOG.isDebugEnabled();
    }

    private class ComponentConfigComponentAdapter
    implements ComponentAdapter {
        private final ComponentConfig myConfig;
        private final ComponentAdapter myDelegate;
        private boolean myInitialized = false;
        private boolean myInitializing = false;

        public ComponentConfigComponentAdapter(final ComponentConfig config, Class<?> implementationClass) {
            this.myConfig = config;
            final String componentKey = config.getInterfaceClass();
            this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)componentKey, implementationClass, null, true)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, ProcessCanceledException {
                    Object componentInstance;
                    block13: {
                        ProgressIndicator indicator = ComponentManagerImpl.getProgressIndicator();
                        if (indicator != null) {
                            indicator.checkCanceled();
                        }
                        componentInstance = null;
                        try {
                            long startTime = ComponentConfigComponentAdapter.this.myInitialized ? 0L : System.nanoTime();
                            componentInstance = super.getComponentInstance(picoContainer);
                            if (ComponentConfigComponentAdapter.this.myInitialized) break block13;
                            if (ComponentConfigComponentAdapter.this.myInitializing) {
                                if (((ComponentConfigComponentAdapter)ComponentConfigComponentAdapter.this).myConfig.pluginDescriptor != null) {
                                    LOG.error((Throwable)new PluginException("Cyclic component initialization: " + componentKey, ((ComponentConfigComponentAdapter)ComponentConfigComponentAdapter.this).myConfig.pluginDescriptor.getPluginId()));
                                } else {
                                    LOG.error(new Throwable("Cyclic component initialization: " + componentKey));
                                }
                            }
                            try {
                                long ms;
                                ComponentConfigComponentAdapter.this.myInitializing = true;
                                ComponentManagerImpl.this.myComponentsRegistry.registerComponentInstance(componentInstance);
                                ComponentManagerImpl.this.initializeComponent(componentInstance, false);
                                if (componentInstance instanceof BaseComponent) {
                                    ((BaseComponent)componentInstance).initComponent();
                                }
                                if ((ms = (System.nanoTime() - startTime) / 1000000L) > 10L && ComponentManagerImpl.this.logSlowComponents()) {
                                    LOG.info(componentInstance.getClass().getName() + " initialized in " + ms + " ms");
                                }
                            }
                            finally {
                                ComponentConfigComponentAdapter.this.myInitializing = false;
                            }
                            ComponentConfigComponentAdapter.this.myInitialized = true;
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (StateStorageException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            ComponentManagerImpl.this.handleInitComponentError(t, componentKey, config);
                        }
                    }
                    return componentInstance;
                }
            };
        }

        public Object getComponentKey() {
            return this.myConfig.getInterfaceClass();
        }

        public Class getComponentImplementation() {
            return this.myDelegate.getComponentImplementation();
        }

        public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            return this.myDelegate.getComponentInstance(container);
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.myDelegate.verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
            this.myDelegate.accept(visitor);
        }
    }

    protected class ComponentsRegistry {
        private final Map<Class, Object> myInterfaceToLockMap = new THashMap();
        private final Map<Class, Class> myInterfaceToClassMap = new THashMap();
        private final List<Class> myComponentInterfaces = new ArrayList<Class>();
        private final Map<String, BaseComponent> myNameToComponent = new THashMap();
        private final List<ComponentConfig> myComponentConfigs = new ArrayList<ComponentConfig>();
        private final List<Object> myImplementations = new ArrayList<Object>();
        private final Map<Class, ComponentConfig> myComponentClassToConfig = new THashMap();
        private boolean myClassesLoaded = false;

        protected ComponentsRegistry() {
        }

        private void loadClasses() {
            assert (!this.myClassesLoaded);
            for (ComponentConfig config : this.myComponentConfigs) {
                this.loadClasses(config);
            }
            this.myClassesLoaded = true;
        }

        private void loadClasses(ComponentConfig config) {
            ClassLoader loader = config.getClassLoader();
            try {
                Class<?> implementationClass;
                Class<?> interfaceClass = Class.forName(config.getInterfaceClass(), true, loader);
                Class<?> clazz = implementationClass = Comparing.equal((String)config.getInterfaceClass(), (String)config.getImplementationClass()) ? interfaceClass : Class.forName(config.getImplementationClass(), true, loader);
                if (this.myInterfaceToClassMap.get(interfaceClass) != null) {
                    throw new RuntimeException("Component already registered: " + interfaceClass.getName());
                }
                ComponentManagerImpl.this.getPicoContainer().registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(config, implementationClass));
                this.myInterfaceToClassMap.put(interfaceClass, implementationClass);
                this.myComponentClassToConfig.put(implementationClass, config);
                this.myComponentInterfaces.add(interfaceClass);
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, null, config);
            }
        }

        private Object getComponentLock(Class componentClass) {
            Object lock = this.myInterfaceToLockMap.get(componentClass);
            if (lock == null) {
                lock = new Object();
                this.myInterfaceToLockMap.put(componentClass, lock);
            }
            return lock;
        }

        private Class[] getComponentInterfaces() {
            assert (this.myClassesLoaded);
            return this.myComponentInterfaces.toArray(new Class[this.myComponentInterfaces.size()]);
        }

        private boolean containsInterface(Class interfaceClass) {
            return this.myInterfaceToClassMap.containsKey(interfaceClass);
        }

        public float getPercentageOfComponentsLoaded() {
            return (float)this.myImplementations.size() / (float)this.myComponentConfigs.size();
        }

        private void registerComponentInstance(Object component) {
            this.myImplementations.add(component);
            if (component instanceof BaseComponent) {
                BaseComponent baseComponent = (BaseComponent)component;
                String componentName = baseComponent.getComponentName();
                if (this.myNameToComponent.containsKey(componentName)) {
                    BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
                    if (!component.equals(loadedComponent)) {
                        LOG.error("Component name collision: " + componentName + " " + loadedComponent.getClass() + " and " + component.getClass());
                    }
                } else {
                    this.myNameToComponent.put(componentName, baseComponent);
                }
            }
        }

        public List<Object> getRegisteredImplementations() {
            return this.myImplementations;
        }

        private void registerComponent(ComponentConfig config) {
            this.myComponentConfigs.add(config);
            if (this.myClassesLoaded) {
                this.loadClasses(config);
            }
        }

        private BaseComponent getComponentByName(String name) {
            return this.myNameToComponent.get(name);
        }

        public <T> T[] getComponentsByType(Class<T> baseClass) {
            ArrayList array = new ArrayList();
            for (int i = 0; i < this.myComponentInterfaces.size(); ++i) {
                Class interfaceClass = this.myComponentInterfaces.get(i);
                Class implClass = this.myInterfaceToClassMap.get(interfaceClass);
                if (!ReflectionUtil.isAssignable(baseClass, (Class)implClass)) continue;
                array.add(ComponentManagerImpl.this.getComponent(interfaceClass));
            }
            return array.toArray((Object[])Array.newInstance(baseClass, array.size()));
        }

        public ComponentConfig[] getComponentConfigurations() {
            return this.myComponentConfigs.toArray(new ComponentConfig[this.myComponentConfigs.size()]);
        }

        public ComponentConfig getConfig(Class componentImplementation) {
            return this.myComponentClassToConfig.get(componentImplementation);
        }
    }
}

