/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.extensions.PluginDescriptor;

class ComponentManagerConfigurator {
    private final ComponentManagerImpl myComponentManager;

    public ComponentManagerConfigurator(ComponentManagerImpl componentManager) {
        this.myComponentManager = componentManager;
    }

    private void loadConfiguration(ComponentConfig[] configs, boolean defaultProject, PluginDescriptor descriptor) {
        for (ComponentConfig config : configs) {
            this.loadSingleConfig(defaultProject, config, descriptor);
        }
    }

    private void loadSingleConfig(boolean defaultProject, ComponentConfig config, PluginDescriptor descriptor) {
        if (defaultProject && !config.isLoadForDefaultProject()) {
            return;
        }
        if (!this.myComponentManager.isComponentSuitable(config.options)) {
            return;
        }
        this.myComponentManager.registerComponent(config, descriptor);
    }

    public void loadComponentsConfiguration(ComponentConfig[] components, PluginDescriptor descriptor, boolean defaultProject) {
        if (components == null) {
            return;
        }
        this.loadConfiguration(components, defaultProject, descriptor);
    }
}

