/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private static final CompositePathMacroFilter ourFilter = new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(ExpandMacroToPathMap result, String macroName, @Nullable String path) {
        if (path == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), "$" + macroName + "$");
    }

    private static void addFileHierarchyReplacements(ExpandMacroToPathMap result, @Nullable VirtualFile f, String macro) {
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd((String)f.getPath(), (String)"/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = "$" + macroName + "$";
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    private static VirtualFileSystem getLocalFileSystem() {
        return VirtualFileManager.getInstance().getFileSystem("file");
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand(entry.getKey(), entry.getValue());
        }
        this.getPathMacros().addMacroExpands(result);
        return result;
    }

    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement(entry.getValue(), entry.getKey());
        }
        this.getPathMacros().addMacroReplacements(result);
        return result;
    }

    @Override
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        return new MyTrackingPathMacroSubstitutor();
    }

    @Override
    public String expandPath(String path) {
        return this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String collapsePath(@Nullable String path) {
        return this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePathsRecursively(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    @Override
    public String collapsePathsRecursively(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        return this.getReplacePathMap().substituteRecursively(text, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/BasePathMacroManager", "expandPaths"));
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePaths"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    public PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        return this.myPathMacros;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private class MyTrackingPathMacroSubstitutor
    implements TrackingPathMacroSubstitutor {
        private final String myLock = new String("MyTrackingPathMacroSubstitutor.lock");
        private final Map<String, Set<String>> myMacroToComponentNames = new FactoryMap<String, Set<String>>(){

            protected Set<String> create(String key) {
                return new HashSet<String>();
            }
        };
        private final Map<String, Set<String>> myComponentNameToMacros = new FactoryMap<String, Set<String>>(){

            protected Set<String> create(String key) {
                return new HashSet<String>();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            String string = this.myLock;
            synchronized (string) {
                this.myMacroToComponentNames.clear();
                this.myComponentNameToMacros.clear();
            }
        }

        @Override
        public String expandPath(String path) {
            return BasePathMacroManager.this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public String collapsePath(@Nullable String path) {
            return BasePathMacroManager.this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void expandPaths(Element element) {
            BasePathMacroManager.this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void collapsePaths(Element element) {
            BasePathMacroManager.this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, false, ourFilter);
        }

        public int hashCode() {
            return BasePathMacroManager.this.getExpandMacroMap().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateUnknownMacros(Set<String> macros) {
            String string = this.myLock;
            synchronized (string) {
                for (String macro : macros) {
                    Set<String> components = this.myMacroToComponentNames.get(macro);
                    for (String component : components) {
                        this.myComponentNameToMacros.remove(component);
                    }
                    this.myMacroToComponentNames.remove(macro);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> getComponents(Collection<String> macros) {
            String string = this.myLock;
            synchronized (string) {
                HashSet<String> result = new HashSet<String>();
                for (String macro : this.myMacroToComponentNames.keySet()) {
                    if (!macros.contains(macro)) continue;
                    result.addAll((Collection<String>)this.myMacroToComponentNames.get(macro));
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> getUnknownMacros(String componentName) {
            String string = this.myLock;
            synchronized (string) {
                HashSet<String> result = new HashSet<String>();
                result.addAll(componentName == null ? this.myMacroToComponentNames.keySet() : this.myComponentNameToMacros.get(componentName));
                return Collections.unmodifiableCollection(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUnknownMacros(String componentName, Collection<String> unknownMacros) {
            if (unknownMacros.isEmpty()) {
                return;
            }
            String string = this.myLock;
            synchronized (string) {
                for (String unknownMacro : unknownMacros) {
                    this.myMacroToComponentNames.get(unknownMacro).add(componentName);
                }
                this.myComponentNameToMacros.get(componentName).addAll(unknownMacros);
            }
        }
    }
}

