/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    public abstract String substitute(String var1, boolean var2);

    public final void substitute(@NotNull Element e, boolean caseSensitive) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e, caseSensitive, false);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        for (Content child : e.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                String oldText;
                Text t = (Text)child;
                if (filter != null && filter.skipPathMacros(t) || (oldText = t.getText()) == (newText = recursively || filter != null && filter.recursePathMacros(t) ? this.substituteRecursively(oldText, caseSensitive) : this.substitute(oldText, caseSensitive))) continue;
                t.setText(newText);
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        for (Attribute attribute : e.getAttributes()) {
            String newValue;
            String oldValue;
            if (filter != null && filter.skipPathMacros(attribute) || (oldValue = attribute.getValue()) == (newValue = recursively || filter != null && filter.recursePathMacros(attribute) ? this.substituteRecursively(oldValue, caseSensitive) : this.substitute(oldValue, caseSensitive))) continue;
            attribute.setValue(newValue);
        }
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e, caseSensitive, recursively, null);
    }

    public String substituteRecursively(String text, boolean caseSensitive) {
        return this.substitute(text, caseSensitive);
    }

    protected static String quotePath(String path) {
        return FileUtil.toSystemIndependentName((String)path);
    }

    public abstract int hashCode();
}

