/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import org.jetbrains.annotations.NotNull;

public abstract class GenericCompiler<Key, SourceState, OutputState>
implements Compiler {
    protected static final KeyDescriptor<String> STRING_KEY_DESCRIPTOR = new EnumeratorStringDescriptor();
    private final String myId;
    private final int myVersion;
    private final CompileOrderPlace myOrderPlace;

    protected GenericCompiler(@NotNull String id, int version, @NotNull CompileOrderPlace orderPlace) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/generic/GenericCompiler", "<init>"));
        }
        if (orderPlace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/compiler/generic/GenericCompiler", "<init>"));
        }
        this.myId = id;
        this.myVersion = version;
        this.myOrderPlace = orderPlace;
    }

    @NotNull
    public abstract KeyDescriptor<Key> getItemKeyDescriptor();

    @NotNull
    public abstract DataExternalizer<SourceState> getSourceStateExternalizer();

    @NotNull
    public abstract DataExternalizer<OutputState> getOutputStateExternalizer();

    @NotNull
    public abstract GenericCompilerInstance<?, ? extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> createInstance(@NotNull CompileContext var1);

    public final String getId() {
        return this.myId;
    }

    public final int getVersion() {
        return this.myVersion;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public CompileOrderPlace getOrderPlace() {
        return this.myOrderPlace;
    }

    public static enum CompileOrderPlace {
        CLASS_INSTRUMENTING,
        CLASS_POST_PROCESSING,
        PACKAGING,
        VALIDATING;

    }
}

