/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModalityStateEx
extends ModalityState {
    private static final WeakReference[] EMPTY_REFS_ARRAY = new WeakReference[0];
    private final WeakReference[] myModalEntities;

    public ModalityStateEx() {
        this(EMPTY_REFS_ARRAY);
    }

    public ModalityStateEx(@NotNull Object[] modalEntities) {
        if (modalEntities == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ModalityStateEx", "<init>"));
        }
        if (modalEntities.length > 0) {
            this.myModalEntities = new WeakReference[modalEntities.length];
            for (int i = 0; i < modalEntities.length; ++i) {
                Object entity = modalEntities[i];
                this.myModalEntities[i] = new WeakReference<Object>(entity);
            }
        } else {
            this.myModalEntities = EMPTY_REFS_ARRAY;
        }
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ModalityStateEx", "appendProgress"));
        }
        ModalityStateEx modalityStateEx = this.appendEntity(progress);
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ModalityStateEx", "appendProgress"));
        }
        return modalityStateEx;
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        if (anEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ModalityStateEx", "appendEntity"));
        }
        ArrayList<Object> list = new ArrayList<Object>(this.myModalEntities.length + 1);
        for (WeakReference modalEntity : this.myModalEntities) {
            Object entity = modalEntity.get();
            if (entity == null) continue;
            list.add(entity);
        }
        list.add(anEntity);
        ModalityStateEx modalityStateEx = new ModalityStateEx(list.toArray());
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ModalityStateEx", "appendEntity"));
        }
        return modalityStateEx;
    }

    private static boolean contains(WeakReference[] array, Object o) {
        for (WeakReference reference : array) {
            Object o1 = reference.get();
            if (o1 == null || !o1.equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean dominates(@NotNull ModalityState anotherState) {
        if (anotherState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/ModalityStateEx", "dominates"));
        }
        if (anotherState == ModalityState.any()) {
            return false;
        }
        for (WeakReference modalEntity : this.myModalEntities) {
            Object entity = modalEntity.get();
            if (entity == null || ModalityStateEx.contains(((ModalityStateEx)anotherState).myModalEntities, entity)) continue;
            return true;
        }
        return false;
    }

    boolean contains(Object modalEntity) {
        return ModalityStateEx.contains(this.myModalEntities, modalEntity);
    }

    @NonNls
    public String toString() {
        if (this.myModalEntities.length == 0) {
            return "ModalityState.NON_MODAL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModalityState:");
        for (int i = 0; i < this.myModalEntities.length; ++i) {
            Object entity = this.myModalEntities[i].get();
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(entity);
        }
        return buffer.toString();
    }
}

