/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final Object LOCK = new Object();
    private static final IdeEventQueue ourEventQueue = IdeEventQueue.getInstance();
    private static final FrequentEventDetector ourFrequentEventDetector = new FrequentEventDetector(1009, 100);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final List<RunnableInfo> ourQueue = new ArrayList<RunnableInfo>();
    private static volatile int ourQueueSkipCount = 0;
    private static final Runnable ourFlushQueueRunnable = new FlushQueue();
    private static final Stack<AWTEvent> ourEventStack = new Stack();
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final List<RunnableInfo> ourForcedFlushQueue = new ArrayList<RunnableInfo>();
    private static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);
    private static final Object RUN_LOCK = new Object();

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "addModalityStateListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator", "addModalityStateListener"));
        }
        ourModalityStateMulticaster.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
        }
        int index = ourModalEntities.indexOf(window);
        if (index < 0) {
            Window owner = window.getOwner();
            if (owner == null) {
                ModalityStateEx modalityStateEx = (ModalityStateEx)ApplicationManager.getApplication().getNoneModalityState();
                if (modalityStateEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
                }
                return modalityStateEx;
            }
            ModalityStateEx ownerState = LaterInvocator.modalityStateForWindow(owner);
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                ModalityStateEx modalityStateEx = ownerState.appendEntity(window);
                if (modalityStateEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
                }
                return modalityStateEx;
            }
            ModalityStateEx modalityStateEx = ownerState;
            if (modalityStateEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
            }
            return modalityStateEx;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entity : ourModalEntities) {
            if (entity instanceof Window) {
                result.add(entity);
                continue;
            }
            if (!(entity instanceof ProgressIndicator) || !((ProgressIndicator)entity).isModal()) continue;
            result.add(entity);
        }
        ModalityStateEx modalityStateEx = new ModalityStateEx(result.toArray());
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
        }
        return modalityStateEx;
    }

    @NotNull
    public static ActionCallback invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable, Conditions.FALSE);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback invokeLater(@NotNull Runnable runnable, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable, modalityState, (Condition<Object>)expired);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback invokeLater(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable, modalityState, (Condition<Object>)Conditions.FALSE);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ActionCallback invokeLater(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<Object> expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ourFrequentEventDetector.eventHappened();
        ActionCallback callback = new ActionCallback();
        RunnableInfo runnableInfo = new RunnableInfo(runnable, modalityState, expired, callback);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    public static void invokeAndWait(final @NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator", "invokeAndWait"));
        }
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        Runnable runnable1 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState);
        semaphore.waitFor();
    }

    public static void enterModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "enterModal"));
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "leaveModal"));
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        boolean removed = ourModalEntities.remove(modalEntity);
        LOG.assertTrue(removed, modalEntity);
        LaterInvocator.cleanupQueueForModal(modalEntity);
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupQueueForModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator", "cleanupQueueForModal"));
        }
        Object object = LOCK;
        synchronized (object) {
            Iterator<RunnableInfo> iterator = ourQueue.iterator();
            while (iterator.hasNext()) {
                ModalityStateEx stateEx;
                RunnableInfo runnableInfo = iterator.next();
                if (!(runnableInfo.modalityState instanceof ModalityStateEx) || !(stateEx = (ModalityStateEx)runnableInfo.modalityState).contains(modalEntity)) continue;
                ourForcedFlushQueue.add(runnableInfo);
                iterator.remove();
            }
        }
    }

    static void leaveAllModals() {
        ourModalEntities.clear();
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object[] objectArray = ArrayUtil.toObjectArray(ourModalEntities);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "getCurrentModalEntities"));
        }
        return objectArray;
    }

    public static boolean isInModalContext() {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        return !ourModalEntities.isEmpty();
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo pollNext() {
        Object object = LOCK;
        synchronized (object) {
            Application application;
            if (!ourForcedFlushQueue.isEmpty()) {
                RunnableInfo toRun = ourForcedFlushQueue.remove(0);
                if (!toRun.expired.value(null)) {
                    return toRun;
                }
                toRun.callback.setDone();
            }
            ModalityStateEx currentModality = ourModalEntities.isEmpty() ? ((application = ApplicationManager.getApplication()) == null ? (ModalityStateEx)ModalityState.NON_MODAL : (ModalityStateEx)application.getNoneModalityState()) : new ModalityStateEx(ourModalEntities.toArray());
            while (ourQueueSkipCount < ourQueue.size()) {
                RunnableInfo info = ourQueue.get(ourQueueSkipCount);
                if (info.expired.value(null)) {
                    ourQueue.remove(ourQueueSkipCount);
                    info.callback.setDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    ourQueue.remove(ourQueueSkipCount);
                    return info;
                }
                ++ourQueueSkipCount;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dumpQueue() {
        Object object = LOCK;
        synchronized (object) {
            String result = "";
            if (!ourForcedFlushQueue.isEmpty()) {
                result = "(Forced queue: " + ourForcedFlushQueue + ") ";
            }
            ArrayList<RunnableInfo> r = new ArrayList<RunnableInfo>(ourQueue);
            result = result + r + (ourQueueSkipCount == 0 ? "" : " (ourQueueSkipCount=" + ourQueueSkipCount + ")") + (ourModalEntities.isEmpty() ? " (non-modal)" : " (modal entities: " + ourModalEntities + ")" + (FLUSHER_SCHEDULED.get() ? " (Flusher scheduled)" : ""));
            return result;
        }
    }

    static /* synthetic */ AtomicBoolean access$400() {
        return FLUSHER_SCHEDULED;
    }

    static /* synthetic */ RunnableInfo access$500() {
        return LaterInvocator.pollNext();
    }

    static /* synthetic */ Object access$600() {
        return RUN_LOCK;
    }

    static /* synthetic */ IdeEventQueue access$700() {
        return ourEventQueue;
    }

    static /* synthetic */ Stack access$800() {
        return ourEventStack;
    }

    static /* synthetic */ Logger access$1000() {
        return LOG;
    }

    static /* synthetic */ boolean access$1100() {
        return DEBUG;
    }

    static /* synthetic */ void access$1200() {
        LaterInvocator.requestFlush();
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block14: {
                LaterInvocator.access$400().set(false);
                this.myLastInfo = lastInfo = LaterInvocator.access$500();
                if (lastInfo == null) break block14;
                var2_2 = LaterInvocator.access$600();
                synchronized (var2_2) {
                    event = LaterInvocator.access$700().getTrueCurrentEvent();
                    LaterInvocator.access$800().push((Object)event);
                    stackSize = LaterInvocator.access$800().size();
                    try {
                        RunnableInfo.access$900(lastInfo).run();
                        RunnableInfo.access$300(lastInfo).setDone();
                    }
                    catch (ProcessCanceledException ex) {
                        LaterInvocator.access$1000().assertTrue(LaterInvocator.access$800().size() == stackSize);
                        LaterInvocator.access$800().pop();
                        if (!LaterInvocator.access$1100()) {
                            this.myLastInfo = null;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof StackOverflowError) {
                            t.printStackTrace();
                        }
                        LaterInvocator.access$1000().error(t);
                        {
                            catch (Throwable var6_7) {
                                LaterInvocator.access$1000().assertTrue(LaterInvocator.access$800().size() == stackSize);
                                LaterInvocator.access$800().pop();
                                if (!LaterInvocator.access$1100()) {
                                    this.myLastInfo = null;
                                }
                                throw var6_7;
                            }
                        }
                        LaterInvocator.access$1000().assertTrue(LaterInvocator.access$800().size() == stackSize);
                        LaterInvocator.access$800().pop();
                        if (!LaterInvocator.access$1100()) {
                            this.myLastInfo = null;
                        } else {
                            ** GOTO lbl48
                        }
                    }
                    LaterInvocator.access$1000().assertTrue(LaterInvocator.access$800().size() == stackSize);
                    LaterInvocator.access$800().pop();
                    if (!LaterInvocator.access$1100()) {
                        this.myLastInfo = null;
                    }
lbl48:
                    // 3 sources

                }
                LaterInvocator.access$1200();
            }
        }

        @NonNls
        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<Object> expired;
        @NotNull
        private final ActionCallback callback;

        public RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<Object> expired, @NotNull ActionCallback callback) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (expired == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback;
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }

        static /* synthetic */ Runnable access$900(RunnableInfo x0) {
            return x0.runnable;
        }
    }
}

