/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    @NonNls
    public static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    @NonNls
    private static final String BUILD_NUMBER_FILE = "build.txt";
    @NonNls
    private static final String PLUGINS_PATH = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";
    @NonNls
    private static final String CONFIG_RELATED_PATH = SystemInfo.isMac ? "" : "config/";
    @NonNls
    private static final String OPTIONS_XML = "options/options.xml";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(String newConfigPath) {
        block1: {
            ImportOldConfigsPanel dialog;
            File instHome;
            ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
            File oldConfigDir = ConfigImportHelper.findOldConfigDir(newConfigPath, settings.getCustomPathsSelector());
            do {
                dialog = new ImportOldConfigsPanel(oldConfigDir, settings);
                dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                AppUIUtil.updateWindowIcon(dialog);
                dialog.setVisible(true);
                if (!dialog.isImportEnabled()) break block1;
            } while (!ConfigImportHelper.validateOldConfigDir(instHome = dialog.getSelectedFile(), oldConfigDir = ConfigImportHelper.getOldConfigDir(instHome, settings), settings));
            ConfigImportHelper.doImport(newConfigPath, oldConfigDir);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
        }
    }

    private static ConfigImportSettings getConfigImportSettings() {
        try {
            Constructor<?> constructor;
            Class<?> customProviderClass = Class.forName("com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings");
            if (customProviderClass != null && ConfigImportSettings.class.isAssignableFrom(customProviderClass) && (constructor = customProviderClass.getDeclaredConstructor(new Class[0])) != null) {
                return (ConfigImportSettings)constructor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException ignored) {
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (InstantiationException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new ConfigImportSettings();
    }

    @Nullable
    private static File findOldConfigDir(String newConfigPath, @Nullable String customPathSelector) {
        File configDir = new File(newConfigPath);
        File selectorDir = CONFIG_RELATED_PATH.length() == 0 ? configDir : configDir.getParentFile();
        File parent = selectorDir.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File maxFile = null;
        long lastModified = 0L;
        String selector = PathManager.getPathsSelector() != null ? PathManager.getPathsSelector() : selectorDir.getName();
        final String prefix = ConfigImportHelper.getPrefixFromSelector(selector);
        final String customPrefix = customPathSelector != null ? ConfigImportHelper.getPrefixFromSelector(customPathSelector) : null;
        for (File file : parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return StringUtil.startsWithIgnoreCase((String)name, (String)prefix) || customPrefix != null && StringUtil.startsWithIgnoreCase((String)name, (String)customPrefix);
            }
        })) {
            long modified;
            File options = new File(file, CONFIG_RELATED_PATH + OPTIONS_XML);
            if (!options.exists() || (modified = options.lastModified()) <= lastModified) continue;
            lastModified = modified;
            maxFile = file;
        }
        return maxFile != null ? new File(maxFile, CONFIG_RELATED_PATH) : null;
    }

    private static String getPrefixFromSelector(String selector) {
        return (SystemInfo.isMac ? "" : ".") + selector.replaceAll("\\d", "");
    }

    public static void doImport(String newConfigPath, File oldConfigDir) {
        try {
            ConfigImportHelper.xcopy(oldConfigDir, new File(newConfigPath));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
        }
    }

    public static boolean validateOldConfigDir(File instHome, File oldConfigDir, ConfigImportSettings settings) {
        if (oldConfigDir == null) {
            String message = !instHome.equals(oldConfigDir) ? ApplicationBundle.message((String)"error.invalid.installation.home", (Object[])new Object[]{instHome.getAbsolutePath(), settings.getProductName(ThreeState.YES)}) : ApplicationBundle.message((String)"error.invalid.config.folder", (Object[])new Object[]{instHome.getAbsolutePath(), settings.getProductName(ThreeState.YES)});
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message);
            return false;
        }
        if (!oldConfigDir.exists()) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.no.settings.path", (Object[])new Object[]{oldConfigDir.getAbsolutePath()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
            return false;
        }
        return true;
    }

    public static void xcopy(File src, File dest) throws IOException {
        File pluginsSettings;
        src = src.getCanonicalFile();
        dest = dest.getCanonicalFile();
        if (!src.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{src.getAbsolutePath()}));
        }
        if (!dest.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{dest.getAbsolutePath()}));
        }
        if (FileUtil.filesEqual((File)src, (File)dest)) {
            return;
        }
        FileUtil.copyDir((File)src, (File)dest);
        File plugins = new File(dest, PLUGINS_PATH);
        if (plugins.exists()) {
            ArrayList<IdeaPluginDescriptorImpl> descriptors = new ArrayList<IdeaPluginDescriptorImpl>();
            PluginManager.loadDescriptors(plugins.getPath(), descriptors, null, 0);
            ArrayList<String> oldPlugins = new ArrayList<String>();
            for (IdeaPluginDescriptorImpl descriptor : descriptors) {
                oldPlugins.add(descriptor.getPluginId().getIdString());
            }
            if (!oldPlugins.isEmpty()) {
                PluginManager.savePluginsList(oldPlugins, false, new File(dest, "installed.txt"));
            }
            FileUtil.delete((File)plugins);
        }
        if ((pluginsSettings = new File(new File(dest, "options"), "plugin_ui.xml")).exists()) {
            FileUtil.delete((File)pluginsSettings);
        }
    }

    @Nullable
    public static File getOldConfigDir(File oldInstallHome, ConfigImportSettings settings) {
        File[] launchFileCandidates;
        if (oldInstallHome == null) {
            return null;
        }
        if (new File(oldInstallHome, OPTIONS_XML).exists()) {
            return oldInstallHome;
        }
        if (new File(oldInstallHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return new File(oldInstallHome, CONFIG_RELATED_PATH);
        }
        int oldBuildNumber = ConfigImportHelper.getBuildNumber(oldInstallHome);
        if (oldBuildNumber != -1 && oldBuildNumber <= 600) {
            return new File(oldInstallHome, "config");
        }
        for (File candidate : launchFileCandidates = ConfigImportHelper.getLaunchFilesCandidates(oldInstallHome, settings)) {
            File probableConfig;
            String configDir;
            if (!candidate.exists() || (configDir = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromLaxFile(candidate, "idea.config.path"), (String)oldInstallHome.getPath())) == null || !(probableConfig = new File(configDir)).exists()) continue;
            return probableConfig;
        }
        for (File candidate : launchFileCandidates) {
            String configDir;
            File probableConfig;
            String pathsSelector;
            if (!candidate.exists() || (pathsSelector = ConfigImportHelper.getPropertyFromLaxFile(candidate, "idea.paths.selector")) == null || !(probableConfig = new File(configDir = PathManager.getDefaultConfigPathFor((String)pathsSelector))).exists()) continue;
            return probableConfig;
        }
        return null;
    }

    private static File[] getLaunchFilesCandidates(@NotNull File instHome, @NotNull ConfigImportSettings settings) {
        if (instHome == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        File bin = new File(instHome, BIN_FOLDER);
        ArrayList<File> files = new ArrayList<File>();
        if (SystemInfo.isMac) {
            files.add(new File(new File(instHome, "Contents"), "Info.plist"));
            files.add(new File(new File(new File(bin, "idea.app"), "Contents"), "Info.plist"));
            files.add(new File(new File(new File(instHome, "idea.app"), "Contents"), "Info.plist"));
        }
        files.add(new File(bin, "idea.properties"));
        String executableName = StringUtil.toLowerCase((String)settings.getExecutableName());
        ConfigImportHelper.addLaunchExecutableScriptsCandidates(files, executableName, bin);
        files.addAll(settings.getCustomLaunchFilesCandidates(instHome, bin));
        if (!"idea".equals(executableName)) {
            ConfigImportHelper.addLaunchExecutableScriptsCandidates(files, "idea", bin);
        }
        return files.toArray(new File[files.size()]);
    }

    private static void addLaunchExecutableScriptsCandidates(List<File> files, String executableName, File binFolder) {
        files.add(new File(binFolder, executableName + ".lax"));
        files.add(new File(binFolder, executableName + ".bat"));
        files.add(new File(binFolder, executableName + ".sh"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getPropertyFromLaxFile(@NotNull File file, @NotNull String propertyName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (file.getName().endsWith(".properties")) {
            try {
                PropertyResourceBundle bundle;
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                try {
                    bundle = new PropertyResourceBundle(fis);
                }
                finally {
                    ((InputStream)fis).close();
                }
                if (bundle.containsKey(propertyName)) {
                    return bundle.getString(propertyName);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        String fileContent = ConfigImportHelper.getContent(file);
        String propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
        if (!StringUtil.isEmpty((String)propertyValue)) {
            return propertyValue;
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String param = propertyName + "=";
        int idx = fileContent.indexOf(param);
        if (idx == -1) {
            param = "<key>" + propertyName + "</key>";
            idx = fileContent.indexOf(param);
            if (idx == -1) {
                return null;
            }
            if ((idx = fileContent.indexOf("<string>", idx)) == -1) {
                return null;
            }
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)), true);
        }
        String configDir = "";
        if (fileContent.length() > (idx += param.length())) {
            if (fileContent.charAt(idx) == '\"') {
                ++idx;
                while (fileContent.length() > idx && fileContent.charAt(idx) != '\"' && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            } else {
                while (fileContent.length() > idx && !Character.isSpaceChar(fileContent.charAt(idx)) && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            }
        }
        if ((configDir = ConfigImportHelper.fixDirName(configDir, true)).length() > 0) {
            configDir = new File(configDir).getPath();
        }
        return configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getContent(File file) {
        try {
            StringBuffer content = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                    content.append('\n');
                }
            }
            finally {
                reader.close();
            }
            return content.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fixDirName(String dir, boolean replaceUserHome) {
        if (StringUtil.startsWithChar((CharSequence)dir, (char)'\"') && StringUtil.endsWithChar((CharSequence)dir, (char)'\"')) {
            dir = dir.substring(1, dir.length() - 1);
        }
        if (replaceUserHome && (dir.startsWith("~\\") || dir.startsWith("~//") || StringUtil.startsWithConcatenation((String)dir, (String[])new String[]{"~", File.separator}))) {
            dir = SystemProperties.getUserHome() + dir.substring(1);
        }
        return dir;
    }

    public static boolean isInstallationHomeOrConfig(@NotNull String installationHome, @NotNull ConfigImportSettings settings) {
        File[] files;
        String[] mainJarNames;
        if (installationHome == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (new File(installationHome, OPTIONS_XML).exists()) {
            return true;
        }
        if (new File(installationHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return true;
        }
        if (!new File(installationHome, BIN_FOLDER).exists()) {
            return false;
        }
        File libFolder = new File(installationHome, "lib");
        boolean quickTest = false;
        for (String name : mainJarNames = settings.getMainJarNames()) {
            String mainJarName = StringUtil.toLowerCase((String)name) + ".jar";
            if (!new File(libFolder, mainJarName).exists()) continue;
            quickTest = true;
            break;
        }
        if (!quickTest) {
            return false;
        }
        for (File file : files = ConfigImportHelper.getLaunchFilesCandidates(new File(installationHome), settings)) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private static int getBuildNumber(File installDirectory) {
        File buildTxt = new File(installDirectory = installDirectory.getAbsoluteFile(), BUILD_NUMBER_FILE);
        if (!buildTxt.exists() || buildTxt.isDirectory()) {
            buildTxt = new File(new File(installDirectory, BIN_FOLDER), BUILD_NUMBER_FILE);
        }
        if (buildTxt.exists() && !buildTxt.isDirectory()) {
            int buildNumber = -1;
            String buildNumberText = ConfigImportHelper.getContent(buildTxt);
            if (buildNumberText != null) {
                try {
                    if (buildNumberText.length() > 1) {
                        buildNumberText = buildNumberText.trim();
                        buildNumber = Integer.parseInt(buildNumberText);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return buildNumber;
        }
        return -1;
    }
}

