/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuickList
implements ExternalizableScheme {
    @NonNls
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    @NonNls
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    @NonNls
    private static final String ID_TAG = "id";
    @NonNls
    private static final String READONLY_TAG = "readonly";
    @NonNls
    private static final String ACTION_TAG = "action";
    @NonNls
    private static final String DISPLAY_NAME_TAG = "display";
    @NonNls
    private static final String DESCRIPTION_TAG = "description";
    private String myDisplayName;
    private String myDescription;
    private String[] myActionIds;
    private boolean myReadonly;
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    QuickList() {
    }

    public QuickList(String displayName, String description, String[] actionIds, boolean isReadonly) {
        this.myDisplayName = displayName == null ? "" : displayName;
        this.myDescription = description == null ? "" : description;
        this.myActionIds = actionIds;
        this.myReadonly = isReadonly;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)o;
        if (!Arrays.equals(this.myActionIds, quickList.myActionIds)) {
            return false;
        }
        if (!this.myDescription.equals(quickList.myDescription)) {
            return false;
        }
        return this.myDisplayName.equals(quickList.myDisplayName);
    }

    public int hashCode() {
        return 29 * this.myDisplayName.hashCode() + this.myDescription.hashCode();
    }

    public String getActionId() {
        return QUICK_LIST_PREFIX + this.getDisplayName();
    }

    public void writeExternal(Element groupElement) {
        groupElement.setAttribute(DISPLAY_NAME_TAG, this.getDisplayName());
        groupElement.setAttribute(DESCRIPTION_TAG, this.getDescription());
        groupElement.setAttribute(READONLY_TAG, String.valueOf(this.isReadonly()));
        for (String actionId : this.getActionIds()) {
            Element actionElement = new Element(ACTION_TAG);
            actionElement.setAttribute(ID_TAG, actionId);
            groupElement.addContent(actionElement);
        }
    }

    public void readExternal(Element element) {
        this.myDisplayName = element.getAttributeValue(DISPLAY_NAME_TAG);
        this.myDescription = element.getAttributeValue(DESCRIPTION_TAG);
        this.myReadonly = Boolean.valueOf(element.getAttributeValue(READONLY_TAG));
        ArrayList<String> ids = new ArrayList<String>();
        Iterator i$ = element.getChildren(ACTION_TAG).iterator();
        while (i$.hasNext()) {
            Element action;
            Element actionElement = action = (Element)i$.next();
            ids.add(actionElement.getAttributeValue(ID_TAG));
        }
        this.myActionIds = ArrayUtil.toStringArray(ids);
    }

    public void setDisplayName(String name) {
        this.myDisplayName = name;
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickList", "getExternalInfo"));
        }
        return externalInfo;
    }

    public void setName(String newName) {
        this.setDisplayName(newName);
    }
}

