/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComputableActionGroup
extends ActionGroup
implements DumbAware {
    private CachedValue<AnAction[]> myChildren;

    protected ComputableActionGroup() {
    }

    protected ComputableActionGroup(boolean popup) {
        super(null, popup);
    }

    public boolean hideIfNoVisibleChildren() {
        return true;
    }

    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ComputableActionGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        if (this.myChildren == null) {
            this.myChildren = new CachedValueImpl<AnAction[]>(this.createChildrenProvider(e.getActionManager()));
        }
        AnAction[] anActionArray = (AnAction[])this.myChildren.getValue();
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ComputableActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    @NotNull
    protected abstract CachedValueProvider<AnAction[]> createChildrenProvider(@NotNull ActionManager var1);

    public static abstract class Simple
    extends ComputableActionGroup {
        @Override
        @NotNull
        protected final CachedValueProvider<AnAction[]> createChildrenProvider(final @NotNull ActionManager actionManager) {
            if (actionManager == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/actionSystem/ComputableActionGroup$Simple", "createChildrenProvider"));
            }
            CachedValueProvider<AnAction[]> cachedValueProvider = new CachedValueProvider<AnAction[]>(){

                @Nullable
                public CachedValueProvider.Result<AnAction[]> compute() {
                    return CachedValueProvider.Result.create((Object)Simple.this.computeChildren(actionManager), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
                }
            };
            if (cachedValueProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ComputableActionGroup$Simple", "createChildrenProvider"));
            }
            return cachedValueProvider;
        }

        @NotNull
        protected abstract AnAction[] computeChildren(@NotNull ActionManager var1);
    }
}

