/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.containers.WeakFactoryMap;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create((String)"MockVirtualFile");
    private final Function<CharSequence, Document> myFactory;
    @Nullable
    private final Key<Reference<Document>> myCachedDocumentKey;
    private final WeakFactoryMap<VirtualFile, Document> myDocuments = new WeakFactoryMap<VirtualFile, Document>(){

        protected Document create(VirtualFile key) {
            if (key.isDirectory() || this.isBinaryWithoutDecompiler(key)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(key);
            Document document = (Document)MockFileDocumentManagerImpl.this.myFactory.fun((Object)text);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, (Object)key);
            return document;
        }

        private boolean isBinaryWithoutDecompiler(VirtualFile file) {
            FileType ft = file.getFileType();
            return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
        }
    };

    public MockFileDocumentManagerImpl(Function<CharSequence, Document> factory, @Nullable Key<Reference<Document>> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "getDocument"));
        }
        return (Document)this.myDocuments.get((Object)file);
    }

    public Document getCachedDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "getCachedDocument"));
        }
        if (this.myCachedDocumentKey != null) {
            Reference reference = (Reference)file.getUserData(this.myCachedDocumentKey);
            return (Document)SoftReference.dereference((Reference)reference);
        }
        return null;
    }

    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "getFile"));
        }
        return (VirtualFile)document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    public void saveAllDocuments() {
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "saveDocument"));
        }
    }

    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "saveDocumentAsIs"));
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        Document[] documentArray = new Document[]{};
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileDocumentManagerImpl", "getUnsavedDocuments"));
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return false;
    }

    public boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "isFileModified"));
        }
        return false;
    }

    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "reloadFromDisk"));
        }
    }

    public void reloadFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "reloadFiles"));
        }
    }

    @NotNull
    public String getLineSeparator(VirtualFile file, Project project) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileDocumentManagerImpl", "getLineSeparator"));
        }
        return "";
    }

    public boolean requestWriting(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockFileDocumentManagerImpl", "requestWriting"));
        }
        return true;
    }
}

