/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.lang.javascript.boilerplate.GithubTagListProvider;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubProjectGeneratorPeer
implements WebProjectGenerator.GeneratorPeer<GithubTagInfo> {
    private static final String CONTROL_PLACE = "Github.Project.Generator.Reload";
    private final List<WebProjectGenerator.SettingsStateListener> myListeners;
    private final GithubTagInfo myMasterTag;
    private final GithubTagListProvider myTagListProvider;
    private final AsyncProcessIcon myLoadingVersionIcon;
    private final JLabel myErrorMessage;
    private JComboBox myComboBox;
    private JComponent myComponent;
    private JPanel myVersionPanel;
    private JPanel myActionPanel;
    private UpdateStatus myUpdateStatus;

    public GithubProjectGeneratorPeer(@NotNull AbstractGithubTagDownloadedProjectGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.newArrayList();
        this.myLoadingVersionIcon = new AsyncProcessIcon("Getting github tags");
        this.myErrorMessage = new JLabel();
        this.myErrorMessage.setForeground((Color)JBColor.RED);
        String ghUserName = generator.getGithubUserName();
        String ghRepoName = generator.getGithubRepositoryName();
        this.myMasterTag = new GithubTagInfo("master", String.format("https://github.com/%s/%s/zipball/master", ghUserName, ghRepoName));
        this.myComboBox.setRenderer(new ListCellRendererWrapper<GithubTagInfo>(){

            public void customize(JList list, GithubTagInfo tag, int index, boolean selected, boolean hasFocus) {
                String text = tag == null ? (GithubProjectGeneratorPeer.this.isBackgroundJobRunning() ? "Loading..." : "Unavailable") : tag.getName();
                this.setText(text);
            }
        });
        this.myTagListProvider = new GithubTagListProvider(ghUserName, ghRepoName);
        this.fillActionPanel();
        ImmutableSet<GithubTagInfo> cachedTags = this.myTagListProvider.getCachedTags();
        if (cachedTags != null) {
            this.onTagsUpdated(cachedTags);
        }
        this.reloadTagsInBackground();
    }

    void onTagsUpdated(@NotNull ImmutableSet<GithubTagInfo> tags) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "onTagsUpdated"));
        }
        this.changeUpdateStatus(UpdateStatus.IDLE);
        if (!this.shouldUpdate(tags)) {
            return;
        }
        List<GithubTagInfo> sortedTags = GithubProjectGeneratorPeer.createSortedTagList(tags);
        GithubTagInfo selectedItem = this.getSelectedTag();
        if (selectedItem == null && sortedTags.size() > 0) {
            selectedItem = sortedTags.get(0);
        }
        this.myComboBox.removeAllItems();
        this.myComboBox.addItem(this.myMasterTag);
        for (GithubTagInfo tag : sortedTags) {
            this.myComboBox.addItem(tag);
        }
        if (selectedItem != null) {
            for (int i = 0; i < this.myComboBox.getItemCount(); ++i) {
                GithubTagInfo item = GithubTagInfo.tryCast(this.myComboBox.getItemAt(i));
                if (item == null || !item.getName().equals(selectedItem.getName())) continue;
                this.myComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.myComboBox.updateUI();
        this.fireStateChanged();
    }

    void onTagsUpdateError(final @NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "onTagsUpdateError"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GithubProjectGeneratorPeer.this.getSelectedTag() == null) {
                    GithubProjectGeneratorPeer.this.myErrorMessage.setText(errorMessage);
                }
                GithubProjectGeneratorPeer.this.changeUpdateStatus(UpdateStatus.IDLE);
            }
        });
    }

    private boolean shouldUpdate(@NotNull ImmutableSet<GithubTagInfo> newTags) {
        if (newTags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "shouldUpdate"));
        }
        if (this.myComboBox.getItemCount() == 0) {
            return true;
        }
        int count = this.myComboBox.getItemCount();
        HashSet oldTags = Sets.newHashSet();
        for (int i = 1; i < count; ++i) {
            GithubTagInfo item = (GithubTagInfo)ObjectUtils.tryCast(this.myComboBox.getItemAt(i), GithubTagInfo.class);
            if (item == null) continue;
            oldTags.add(item);
        }
        return !((Object)oldTags).equals(newTags);
    }

    @NotNull
    private static List<GithubTagInfo> createSortedTagList(@NotNull ImmutableCollection<GithubTagInfo> tags) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "createSortedTagList"));
        }
        ArrayList sortedTags = ContainerUtil.newArrayList(tags);
        Collections.sort(sortedTags, new Comparator<GithubTagInfo>(){

            @Override
            public int compare(GithubTagInfo tag1, GithubTagInfo tag2) {
                GithubTagInfo.Version v1 = tag1.getVersion();
                GithubTagInfo.Version v2 = tag2.getVersion();
                return v2.compareTo(v1);
            }
        });
        for (GithubTagInfo tag : sortedTags) {
            tag.setRecentTag(false);
        }
        if (!sortedTags.isEmpty()) {
            ((GithubTagInfo)sortedTags.get(0)).setRecentTag(true);
        }
        ArrayList arrayList = sortedTags;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "createSortedTagList"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "buildUI"));
        }
        settingsStep.addSettingsField("\u001bVersion:", (JComponent)this.myVersionPanel);
        settingsStep.addSettingsComponent((JComponent)this.myErrorMessage);
    }

    @Override
    @NotNull
    public GithubTagInfo getSettings() {
        GithubTagInfo tag = this.getSelectedTag();
        if (tag == null) {
            throw new RuntimeException("[internal error] No versions available.");
        }
        GithubTagInfo githubTagInfo = tag;
        if (githubTagInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "getSettings"));
        }
        return githubTagInfo;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        GithubTagInfo tag = this.getSelectedTag();
        if (tag != null) {
            return null;
        }
        String errorMessage = StringUtil.notNullize((String)this.myErrorMessage.getText());
        if (errorMessage.isEmpty()) {
            errorMessage = "Versions have not been loaded yet.";
        }
        return new ValidationInfo(errorMessage);
    }

    @Override
    public boolean isBackgroundJobRunning() {
        return this.myUpdateStatus == UpdateStatus.UPDATING;
    }

    @Override
    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "addSettingsStateListener"));
        }
        this.myListeners.add(listener);
    }

    @Nullable
    private GithubTagInfo getSelectedTag() {
        return GithubTagInfo.tryCast(this.myComboBox.getSelectedItem());
    }

    private void fireStateChanged() {
        GithubTagInfo tag = this.getSelectedTag();
        for (WebProjectGenerator.SettingsStateListener listener : this.myListeners) {
            listener.stateChanged(tag != null);
        }
    }

    private void reloadTagsInBackground() {
        this.changeUpdateStatus(UpdateStatus.UPDATING);
        this.myErrorMessage.setText(null);
        this.myTagListProvider.updateTagListAsynchronously(this);
    }

    private void changeUpdateStatus(@NotNull UpdateStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "changeUpdateStatus"));
        }
        CardLayout cardLayout = (CardLayout)this.myActionPanel.getLayout();
        cardLayout.show(this.myActionPanel, status.name());
        if (status == UpdateStatus.UPDATING) {
            this.myLoadingVersionIcon.resume();
        } else {
            this.myLoadingVersionIcon.suspend();
        }
        this.myUpdateStatus = status;
    }

    private void fillActionPanel() {
        this.myActionPanel.add((Component)this.createReloadButtonPanel(), UpdateStatus.IDLE.name());
        this.myActionPanel.add((Component)this.createReloadInProgressPanel(), UpdateStatus.UPDATING.name());
        this.changeUpdateStatus(UpdateStatus.IDLE);
    }

    @NotNull
    private JPanel createReloadButtonPanel() {
        ReloadAction reloadAction = new ReloadAction();
        ActionButton reloadButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), CONTROL_PLACE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)reloadButton, "West");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "createReloadButtonPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createReloadInProgressPanel() {
        JPanel panel = new JPanel();
        panel.add((Component)this.myLoadingVersionIcon);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer", "createReloadInProgressPanel"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel();
        this.myComponent = jPanel3;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVersionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myActionPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Version:");
        jLabel.setDisplayedMnemonic('V');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private class ReloadAction
    extends AnAction {
        private ReloadAction() {
            super("Reload versions", null, AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e) {
            GithubProjectGeneratorPeer.this.reloadTagsInBackground();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }
    }

    private static enum UpdateStatus {
        UPDATING,
        IDLE;

    }
}

