/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoCustomRegionDialog
extends DialogWrapper {
    private JBList myRegionsList;
    private JPanel myContentPane;
    private JBScrollPane myScrollPane;
    private final Editor myEditor;
    private final Project myProject;

    protected GotoCustomRegionDialog(@Nullable Project project, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/customFolding/GotoCustomRegionDialog", "<init>"));
        }
        super(project);
        this.myEditor = editor;
        this.myProject = project;
        this.$$$setupUI$$$();
        Collection<FoldingDescriptor> descriptors = this.getCustomFoldingDescriptors();
        this.init();
        if (descriptors.size() == 0) {
            this.myScrollPane.setVisible(false);
            this.myContentPane.add((Component)new JLabel(IdeBundle.message((String)"goto.custom.region.message.unavailable", (Object[])new Object[0])), "North");
            this.setOKActionEnabled(false);
        } else {
            this.myRegionsList.setModel((ListModel)new MyListModel(GotoCustomRegionDialog.orderByPosition(descriptors)));
            this.myRegionsList.setSelectedIndex(0);
        }
        this.setTitle(IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0]));
    }

    public JComponent getPreferredFocusedComponent() {
        if (!this.myRegionsList.isEmpty()) {
            return this.myRegionsList;
        }
        return super.getPreferredFocusedComponent();
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private Collection<FoldingDescriptor> getCustomFoldingDescriptors() {
        PsiFile file;
        HashSet foldingDescriptors = new HashSet();
        Document document = this.myEditor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        PsiFile psiFile = file = documentManager != null ? documentManager.getPsiFile(document) : null;
        if (file != null) {
            FileViewProvider viewProvider = file.getViewProvider();
            for (Language language : viewProvider.getLanguages()) {
                PsiFile psi = viewProvider.getPsi(language);
                FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
                if (psi == null) continue;
                for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)false)) {
                    CustomFoldingBuilder customFoldingBuilder = GotoCustomRegionDialog.getCustomFoldingBuilder(foldingBuilder, descriptor);
                    if (customFoldingBuilder == null || !customFoldingBuilder.isCustomRegionStart(descriptor.getElement())) continue;
                    foldingDescriptors.add(descriptor);
                }
            }
        }
        return foldingDescriptors;
    }

    private static Collection<FoldingDescriptor> orderByPosition(Collection<FoldingDescriptor> descriptors) {
        ArrayList<FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, new Comparator<FoldingDescriptor>(){

            @Override
            public int compare(FoldingDescriptor descriptor1, FoldingDescriptor descriptor2) {
                int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
                int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
                return pos1 - pos2;
            }
        });
        return sorted;
    }

    private void createUIComponents() {
        this.myRegionsList = new JBList();
        this.myScrollPane = new JBScrollPane((Component)this.myRegionsList);
    }

    @Nullable
    private static CustomFoldingBuilder getCustomFoldingBuilder(FoldingBuilder builder, FoldingDescriptor descriptor) {
        if (builder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)builder;
        }
        FoldingBuilder originalBuilder = (FoldingBuilder)descriptor.getElement().getUserData(CompositeFoldingBuilder.FOLDING_BUILDER);
        if (originalBuilder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)originalBuilder;
        }
        return null;
    }

    @Nullable
    public PsiElement getNavigationElement() {
        Object selection = this.myRegionsList.getSelectedValue();
        if (selection instanceof MyFoldingDescriptorWrapper) {
            return ((MyFoldingDescriptorWrapper)selection).getDescriptor().getElement().getPsi();
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JBScrollPane jBScrollPane = this.myScrollPane;
        jPanel.add((Component)jBScrollPane, "Center");
        JBList jBList = this.myRegionsList;
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/customFolding/GotoCustomRegionDialog$MyFoldingDescriptorWrapper", "<init>"));
            }
            this.myDescriptor = descriptor;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            FoldingDescriptor foldingDescriptor = this.myDescriptor;
            if (foldingDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/customFolding/GotoCustomRegionDialog$MyFoldingDescriptorWrapper", "getDescriptor"));
            }
            return foldingDescriptor;
        }

        @Nullable
        public String toString() {
            return this.myDescriptor.getPlaceholderText();
        }
    }

    private static class MyListModel
    extends DefaultListModel {
        private MyListModel(Collection<FoldingDescriptor> descriptors) {
            for (FoldingDescriptor descriptor : descriptors) {
                super.addElement(new MyFoldingDescriptorWrapper(descriptor));
            }
        }
    }
}

