/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerExImpl;
import com.intellij.javaee.ExternalResourceManagerImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalResourcesRootsProvider
extends IndexableSetContributor {
    private final NotNullLazyValue<Set<String>> myStandardResources = new NotNullLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            ExternalResourceManagerImpl manager = (ExternalResourceManagerImpl)ExternalResourceManager.getInstance();
            Collection<Map<String, ExternalResourceManagerExImpl.Resource>> resources = manager.getStandardResources();
            HashSet<ExternalResourceManagerExImpl.Resource> dirs = new HashSet<ExternalResourceManagerExImpl.Resource>();
            HashSet<String> set = new HashSet<String>();
            for (Map<String, ExternalResourceManagerExImpl.Resource> map : resources) {
                for (ExternalResourceManagerExImpl.Resource resource : map.values()) {
                    String url;
                    ExternalResourceManagerExImpl.Resource dir = new ExternalResourceManagerExImpl.Resource();
                    int i = resource.file.lastIndexOf(47);
                    dir.file = i > 0 ? resource.file.substring(0, i) : resource.file;
                    dir.classLoader = resource.classLoader;
                    dir.clazz = resource.clazz;
                    if (!dirs.add(dir) || (url = resource.getResourceUrl()) == null) continue;
                    set.add(url.substring(0, url.lastIndexOf(47)));
                }
            }
            HashSet<String> hashSet = set;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourcesRootsProvider$1", "compute"));
            }
            return hashSet;
        }
    };

    @Override
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (String url : (Set)this.myStandardResources.getValue()) {
            VirtualFile file = VfsUtil.findRelativeFile((String)url, null);
            if (file == null) continue;
            roots.add(file);
        }
        String path = FetchExtResourceAction.getExternalResourcesPath();
        VirtualFile extResources = LocalFileSystem.getInstance().findFileByPath(path);
        ContainerUtil.addIfNotNull((Object)extResources, roots);
        return roots;
    }
}

