/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.PatchedUsage;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BasicSentUsagesPersistenceComponent
extends SentUsagesPersistence {
    protected Map<GroupDescriptor, Set<UsageDescriptor>> mySentDescriptors = new HashMap();
    @NonNls
    private long mySentTime = 0L;

    @Override
    public boolean isAllowed() {
        return true;
    }

    @Override
    public boolean isShowNotification() {
        return false;
    }

    @Override
    public long getLastTimeSent() {
        return this.mySentTime;
    }

    public void setSentTime(long time) {
        this.mySentTime = time;
    }

    @Override
    public void persistPatch(@NotNull Map<GroupDescriptor, Set<PatchedUsage>> patchedDescriptorMap) {
        if (patchedDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/persistence/BasicSentUsagesPersistenceComponent", "persistPatch"));
        }
        for (Map.Entry<GroupDescriptor, Set<PatchedUsage>> entry : patchedDescriptorMap.entrySet()) {
            GroupDescriptor groupDescriptor = entry.getKey();
            for (PatchedUsage patchedUsage : entry.getValue()) {
                Object usageDescriptor = StatisticsUploadAssistant.findDescriptor(this.mySentDescriptors, (Pair<GroupDescriptor, String>)Pair.create((Object)groupDescriptor, (Object)patchedUsage.getKey()));
                if (usageDescriptor != null) {
                    ((UsageDescriptor)usageDescriptor).setValue(((UsageDescriptor)usageDescriptor).getValue() + patchedUsage.getDelta());
                    continue;
                }
                if (!this.mySentDescriptors.containsKey(groupDescriptor)) {
                    this.mySentDescriptors.put(groupDescriptor, (Set<UsageDescriptor>)new HashSet());
                }
                this.mySentDescriptors.get(groupDescriptor).add(new UsageDescriptor(patchedUsage.getKey(), patchedUsage.getValue()));
            }
        }
        this.setSentTime(System.currentTimeMillis());
    }

    @Override
    @NotNull
    public Map<GroupDescriptor, Set<UsageDescriptor>> getSentUsages() {
        Map<GroupDescriptor, Set<UsageDescriptor>> map = this.mySentDescriptors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/BasicSentUsagesPersistenceComponent", "getSentUsages"));
        }
        return map;
    }
}

