/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class FocusTracesDialog
extends DialogWrapper {
    private JTextPane myStacktrace;
    private JBTable myRequestsTable;
    private JPanel myRootPanel;
    private final List<FocusRequestInfo> myRequests;
    private static final String[] COLUMNS = new String[]{"Time", "Forced", "Component"};

    public FocusTracesDialog(Project project, ArrayList<FocusRequestInfo> requests) {
        super(project);
        this.myRequests = requests;
        this.$$$setupUI$$$();
        this.setTitle("Focus Traces");
        this.init();
        Object[][] data = new String[requests.size()][];
        for (int i = 0; i < data.length; ++i) {
            FocusRequestInfo r = requests.get(i);
            data[i] = new String[]{r.getDate(), String.valueOf(r.isForced()), String.valueOf(r.getComponent())};
        }
        this.myRequestsTable.setModel((TableModel)new DefaultTableModel(data, COLUMNS));
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = FocusTracesDialog.this.myRequestsTable.getSelectedRow();
                if (-1 < index && index < FocusTracesDialog.this.myRequests.size()) {
                    FocusTracesDialog.this.myStacktrace.setText(((FocusRequestInfo)FocusTracesDialog.this.myRequests.get(index)).getStackTrace());
                } else {
                    FocusTracesDialog.this.myStacktrace.setText("");
                }
            }
        };
        this.myRequestsTable.getSelectionModel().addListSelectionListener(selectionListener);
        TableColumnModel columnModel = this.myRequestsTable.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(120);
        columnModel.getColumn(1).setMaxWidth(60);
        columnModel.getSelectionModel().addListSelectionListener(selectionListener);
        columnModel.setColumnSelectionAllowed(false);
        this.myRequestsTable.getSelectionModel().setSelectionMode(0);
        this.myRequestsTable.changeSelection(0, 0, false, true);
    }

    protected String getDimensionServiceKey() {
        return "ide.internal.focus.trace.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRequestsTable;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCopyStackTraceAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/focus/FocusTracesDialog", "createActions"));
        }
        return actionArray;
    }

    private Action getCopyStackTraceAction() {
        return new AbstractAction("&Copy stacktrace"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(FocusTracesDialog.this.myStacktrace.getText()));
            }
        };
    }

    public void show() {
        BorderDrawer drawer = new BorderDrawer();
        drawer.start();
        super.show();
        drawer.setDone();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JTextPane jTextPane;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 400));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jPanel.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myStacktrace = jTextPane = new JTextPane();
        jSplitPane.setRightComponent(jTextPane);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setMinimumSize(new Dimension(23, 250));
        jSplitPane.setLeftComponent((Component)jBScrollPane);
        this.myRequestsTable = jBTable = new JBTable();
        jBTable.setMinimumSize(new Dimension(30, 250));
        jBTable.setAutoResizeMode(3);
        jBTable.setPreferredSize(new Dimension(150, 150));
        jBTable.setAutoscrolls(false);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    class BorderDrawer
    extends Thread {
        Component prev;
        private volatile boolean running;

        BorderDrawer() {
            super("Focus Border Drawer");
            this.prev = null;
            this.running = true;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    BorderDrawer.sleep(100L);
                    this.paintBorder();
                }
                if (this.prev != null) {
                    this.prev.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void paintBorder() {
            int row = FocusTracesDialog.this.myRequestsTable.getSelectedRow();
            if (row != -1) {
                FocusRequestInfo info = (FocusRequestInfo)FocusTracesDialog.this.myRequests.get(row);
                if (this.prev != null && this.prev != info.getComponent()) {
                    this.prev.repaint();
                }
                this.prev = info.getComponent();
                if (this.prev != null && this.prev.isDisplayable()) {
                    Graphics g = this.prev.getGraphics();
                    g.setColor((Color)JBColor.RED);
                    Dimension sz = this.prev.getSize();
                    UIUtil.drawDottedRectangle((Graphics)g, (int)1, (int)1, (int)(sz.width - 2), (int)(sz.height - 2));
                }
            }
        }

        public void setDone() {
            this.running = false;
        }
    }
}

