/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends AnAction
implements DumbAware {
    private volatile boolean myDumb = false;

    public void actionPerformed(AnActionEvent e) {
        if (this.myDumb) {
            this.myDumb = false;
        } else {
            this.myDumb = true;
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            CacheUpdater updater = new CacheUpdater(){

                public int getNumberOfPendingUpdateJobs() {
                    return 0;
                }

                @NotNull
                public VirtualFile[] queryNeededFiles(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/ToggleDumbModeAction$1", "queryNeededFiles"));
                    }
                    while (ToggleDumbModeAction.this.myDumb) {
                        TimeoutUtil.sleep((long)100L);
                    }
                    if (VirtualFile.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ToggleDumbModeAction$1", "queryNeededFiles"));
                    }
                    return VirtualFile.EMPTY_ARRAY;
                }

                public void processFile(@NotNull FileContent fileContent) {
                    if (fileContent == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/ToggleDumbModeAction$1", "processFile"));
                    }
                }

                public void updatingDone() {
                }

                public void canceled() {
                }
            };
            DumbServiceImpl.getInstance(project).queueCacheUpdateInDumbMode(Arrays.asList(updater));
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        presentation.setEnabled(project != null && this.myDumb == DumbServiceImpl.getInstance(project).isDumb());
        if (this.myDumb) {
            presentation.setText("Exit dumb mode");
        } else {
            presentation.setText("Enter dumb mode");
        }
    }
}

