/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;

public class VirtualFileWindowImpl
extends LightVirtualFile
implements VirtualFileWindow {
    private final VirtualFile myDelegate;
    private final DocumentWindowImpl myDocumentWindow;

    public VirtualFileWindowImpl(@NotNull VirtualFile delegate, @NotNull DocumentWindowImpl window, @NotNull Language language, @NotNull CharSequence text) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/injected/editor/VirtualFileWindowImpl", "<init>"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/injected/editor/VirtualFileWindowImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/injected/editor/VirtualFileWindowImpl", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/injected/editor/VirtualFileWindowImpl", "<init>"));
        }
        super(delegate.getName(), language, text);
        this.setCharset(delegate.getCharset());
        this.setFileType((FileType)language.getAssociatedFileType());
        this.myDelegate = delegate;
        this.myDocumentWindow = window;
    }

    public VirtualFile getDelegate() {
        return this.myDelegate;
    }

    public DocumentWindowImpl getDocumentWindow() {
        return this.myDocumentWindow;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public boolean isWritable() {
        return this.getDelegate().isWritable();
    }

    public String toString() {
        return "VirtualFileWindow in " + this.myDelegate.getPresentableUrl();
    }
}

