/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ui.PlaceHolder;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TreeStructureUtil {
    public static final String PLACE = "StructureViewPopup";

    private TreeStructureUtil() {
    }

    public static Object[] getChildElementsFromTreeStructure(AbstractTreeStructure treeStructure, Object element) {
        Object[] items = treeStructure.getChildElements(element);
        HashSet<Object> viewedItems = new HashSet<Object>();
        for (Object item : items) {
            if (viewedItems.contains(item)) continue;
            viewedItems.add(item);
        }
        return items;
    }

    public static boolean isInStructureViewPopup(@NotNull PlaceHolder<String> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/treeView/smartTree/TreeStructureUtil", "isInStructureViewPopup"));
        }
        return PLACE.equals(model.getPlace());
    }

    @NonNls
    public static String getPropertyName(String propertyName) {
        return propertyName + ".file.structure.state";
    }
}

