/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectStructureDetector {
    public static final ExtensionPointName<ProjectStructureDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectStructureDetector");

    @NotNull
    public abstract DirectoryProcessingResult detectRoots(@NotNull File var1, @NotNull File[] var2, @NotNull File var3, @NotNull List<DetectedProjectRoot> var4);

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        return Collections.emptyList();
    }

    public String getDetectorId() {
        return this.getClass().getName();
    }

    public void setupProjectStructure(@NotNull Collection<DetectedProjectRoot> roots, @NotNull ProjectDescriptor projectDescriptor, @NotNull ProjectFromSourcesBuilder builder) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/projectWizard/importSources/ProjectStructureDetector", "setupProjectStructure"));
        }
        if (projectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/projectWizard/importSources/ProjectStructureDetector", "setupProjectStructure"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/projectWizard/importSources/ProjectStructureDetector", "setupProjectStructure"));
        }
    }

    public static class DirectoryProcessingResult {
        private boolean myProcessChildren;
        private File myParentToSkip;
        public static final DirectoryProcessingResult PROCESS_CHILDREN = new DirectoryProcessingResult(true, null);
        public static final DirectoryProcessingResult SKIP_CHILDREN = new DirectoryProcessingResult(false, null);

        public static DirectoryProcessingResult skipChildrenAndParentsUpTo(@NotNull File parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/projectWizard/importSources/ProjectStructureDetector$DirectoryProcessingResult", "skipChildrenAndParentsUpTo"));
            }
            return new DirectoryProcessingResult(false, parent);
        }

        private DirectoryProcessingResult(boolean processChildren, File parentToSkip) {
            this.myProcessChildren = processChildren;
            this.myParentToSkip = parentToSkip;
        }

        public boolean isProcessChildren() {
            return this.myProcessChildren;
        }

        @Nullable
        public File getParentToSkip() {
            return this.myParentToSkip;
        }
    }
}

