/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.impl;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportModelBase
extends UserDataHolderBase
implements FrameworkSupportModel {
    private final Project myProject;
    private final ModuleBuilder myModuleBuilder;
    private final LibrariesContainer myLibrariesContainer;
    private final EventDispatcher<FrameworkSupportModelListener> myDispatcher;
    private final EventDispatcher<FrameworkVersionListener> myVersionEventDispatcher;
    private final Map<String, FrameworkSupportNode> mySettingsMap;
    private final Map<String, FrameworkSupportOptionsComponent> myOptionsComponentsMap;
    private final Map<String, FrameworkVersion> mySelectedVersions;
    private final Map<String, String> myFrameworkVersions;
    private FrameworkLibraryProvider myLibraryProvider;

    public FrameworkSupportModelBase(@Nullable Project project, @Nullable ModuleBuilder builder, @NotNull LibrariesContainer librariesContainer) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(FrameworkSupportModelListener.class);
        this.myVersionEventDispatcher = EventDispatcher.create(FrameworkVersionListener.class);
        this.mySettingsMap = new HashMap<String, FrameworkSupportNode>();
        this.myOptionsComponentsMap = new HashMap<String, FrameworkSupportOptionsComponent>();
        this.mySelectedVersions = new HashMap<String, FrameworkVersion>();
        this.myFrameworkVersions = new HashMap<String, String>();
        this.myProject = project;
        this.myModuleBuilder = builder;
        this.myLibrariesContainer = librariesContainer;
    }

    @NotNull
    public abstract String getBaseDirectoryForLibrariesPath();

    public void registerComponent(@NotNull FrameworkSupportInModuleProvider provider, @NotNull FrameworkSupportNode node) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "registerComponent"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "registerComponent"));
        }
        this.mySettingsMap.put(provider.getFrameworkType().getId(), node);
    }

    public void registerOptionsComponent(FrameworkSupportInModuleProvider provider, FrameworkSupportOptionsComponent component) {
        this.myOptionsComponentsMap.put(provider.getFrameworkType().getId(), component);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myModuleBuilder;
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "isFrameworkSelected"));
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        return node != null && node.isChecked();
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "addFrameworkListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "addFrameworkListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "addFrameworkListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void addFrameworkVersionListener(@NotNull FrameworkVersionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "addFrameworkVersionListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "addFrameworkVersionListener"));
        }
        this.myVersionEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "removeFrameworkListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setFrameworkComponentEnabled(@NotNull @NonNls String providerId, boolean enable) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "setFrameworkComponentEnabled"));
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node != null && enable != node.isChecked()) {
            node.setChecked(enable);
        }
    }

    public void updateFrameworkLibraryComponent(@NotNull String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "updateFrameworkLibraryComponent"));
        }
        FrameworkSupportOptionsComponent component = this.myOptionsComponentsMap.get(providerId);
        if (component != null) {
            component.updateLibrariesPanel();
        }
    }

    public FrameworkSupportConfigurable getFrameworkConfigurable(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "getFrameworkConfigurable"));
        }
        FrameworkSupportConfigurable configurable = this.findFrameworkConfigurable(providerId);
        if (configurable == null) {
            throw new IllegalArgumentException("provider '" + providerId + " not found");
        }
        return configurable;
    }

    @Nullable
    public FrameworkSupportConfigurable findFrameworkConfigurable(@NotNull @NonNls String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "findFrameworkConfigurable"));
        }
        FrameworkSupportNode node = this.mySettingsMap.get(providerId);
        if (node == null) {
            return null;
        }
        return ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)node.getConfigurable()).getConfigurable();
    }

    public void setSelectedVersion(@NotNull String frameworkOrGroupId, @NotNull FrameworkVersion version) {
        if (frameworkOrGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "setSelectedVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "setSelectedVersion"));
        }
        FrameworkVersion oldVersion = this.mySelectedVersions.put(frameworkOrGroupId, version);
        if (!Comparing.equal((Object)oldVersion, (Object)version)) {
            for (Map.Entry<String, FrameworkSupportNode> entry : this.mySettingsMap.entrySet()) {
                FrameworkSupportOptionsComponent component;
                if (!FrameworkSupportModelBase.hasParentWithId(entry.getValue(), frameworkOrGroupId)) continue;
                if (!entry.getValue().getId().equals(frameworkOrGroupId) && (component = this.myOptionsComponentsMap.get(entry.getKey())) != null) {
                    component.updateVersionsComponent();
                }
                this.updateFrameworkLibraryComponent(entry.getKey());
            }
        }
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged(version);
    }

    private static boolean hasParentWithId(FrameworkSupportNode node, @NotNull String frameworkOrGroupId) {
        if (frameworkOrGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "hasParentWithId"));
        }
        for (FrameworkSupportNodeBase current = node; current != null; current = current.getParentNode()) {
            if (!current.getId().equals(frameworkOrGroupId)) continue;
            return true;
        }
        return false;
    }

    public FrameworkLibraryProvider getLibraryProvider() {
        return this.myLibraryProvider;
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider libraryProvider) {
        this.myLibraryProvider = libraryProvider;
        for (FrameworkSupportOptionsComponent optionsComponent : this.myOptionsComponentsMap.values()) {
            optionsComponent.updateLibrariesPanel();
        }
    }

    @Nullable
    public <V extends FrameworkVersion> V getSelectedVersion(@NotNull String frameworkOrGroupId) {
        if (frameworkOrGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "getSelectedVersion"));
        }
        return (V)this.mySelectedVersions.get(frameworkOrGroupId);
    }

    public void onFrameworkSelectionChanged(FrameworkSupportNode node) {
        FrameworkSupportInModuleProvider provider = (FrameworkSupportInModuleProvider)node.getUserObject();
        boolean checked = node.isChecked();
        if (provider instanceof OldFrameworkSupportProviderWrapper) {
            FrameworkSupportProvider oldProvider = ((OldFrameworkSupportProviderWrapper)provider).getProvider();
            this.selectFramework(oldProvider, checked);
        }
        for (FrameworkSupportInModuleProvider.FrameworkDependency dependency : provider.getDependenciesFrameworkIds()) {
            if (dependency.isOptional()) continue;
            String id = dependency.getFrameworkId();
            this.setFrameworkComponentEnabled(id, true);
        }
    }

    public void selectFramework(FrameworkSupportProvider provider, boolean checked) {
        FrameworkSupportModelListener multicaster = (FrameworkSupportModelListener)this.myDispatcher.getMulticaster();
        if (checked) {
            multicaster.frameworkSelected(provider);
        } else {
            multicaster.frameworkUnselected(provider);
        }
    }

    public void fireWizardStepUpdated() {
        ((FrameworkSupportModelListener)this.myDispatcher.getMulticaster()).wizardStepUpdated();
    }

    @NotNull
    public LibrariesContainer getLibrariesContainer() {
        LibrariesContainer librariesContainer = this.myLibrariesContainer;
        if (librariesContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase", "getLibrariesContainer"));
        }
        return librariesContainer;
    }

    public void setSelectedLibraryVersion(String id, String version) {
        this.myFrameworkVersions.put(id, version);
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged((FrameworkVersion)this.getSelectedVersion(id));
    }

    public String getFrameworkVersion(String id) {
        FrameworkVersion version = this.mySelectedVersions.get(id);
        return version == null ? this.myFrameworkVersions.get(id) : version.getVersionNumber();
    }
}

