/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
CustomMatcherModel,
Comparator<Object> {
    @NonNls
    public static final String SETTINGS_KEY = "$$$SETTINGS$$$";
    @NonNls
    public static final String INTENTIONS_KEY = "$$$INTENTIONS_KEY$$$";
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private Pattern myCompiledPattern;
    protected final SearchableOptionsRegistrar myIndex;
    protected final Map<AnAction, String> myActionsMap = new TreeMap<AnAction, String>(new Comparator<AnAction>(){

        @Override
        public int compare(AnAction o1, AnAction o2) {
            int compare = Comparing.compare((Comparable)((Object)o1.getTemplatePresentation().getText()), (Comparable)((Object)o2.getTemplatePresentation().getText()));
            if (compare == 0 && !o1.equals(o2)) {
                return o1.hashCode() - o2.hashCode();
            }
            return compare;
        }
    });
    protected final Map<String, ApplyIntentionAction> myIntentions = new TreeMap<String, ApplyIntentionAction>();
    private final ThreadLocal<PatternMatcher> myMatcher = new ThreadLocal<PatternMatcher>(){

        @Override
        protected PatternMatcher initialValue() {
            return new Perl5Matcher();
        }
    };

    public GotoActionModel(@Nullable Project project, Component component) {
        this(project, component, null, null);
    }

    public GotoActionModel(@Nullable Project project, Component component, @Nullable Editor editor, @Nullable PsiFile file) {
        ApplyIntentionAction[] children;
        this.myProject = project;
        this.myContextComponent = component;
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        this.collectActions(this.myActionsMap, mainMenu, mainMenu.getTemplatePresentation().getText());
        if (project != null && editor != null && file != null && (children = ApplyIntentionAction.getAvailableIntentions(editor, file)) != null) {
            for (ApplyIntentionAction action : children) {
                this.myIntentions.put(action.getName(), action);
            }
        }
        this.myIndex = SearchableOptionsRegistrar.getInstance();
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.other.included", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return 'd';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.menu.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = this.getPropertiesStorage();
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToAction.toSaveAllIncluded")) && propertiesComponent.isTrueValue("GoToAction.allIncluded");
    }

    private PropertiesComponent getPropertiesStorage() {
        return this.myProject != null ? PropertiesComponent.getInstance((Project)this.myProject) : PropertiesComponent.getInstance();
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = this.getPropertiesStorage();
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToAction.toSaveAllIncluded"))) {
            propertiesComponent.setValue("GoToAction.allIncluded", Boolean.toString(state));
        }
    }

    public ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBorder(IdeBorderFactory.createEmptyBorder((int)2));
                panel.setOpaque(true);
                Color bg = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
                panel.setBackground(bg);
                if (value instanceof Map.Entry) {
                    Map.Entry actionWithParentGroup = (Map.Entry)value;
                    AnAction anAction = (AnAction)actionWithParentGroup.getKey();
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon = templatePresentation.getIcon();
                    DataContext dataContext = DataManager.getInstance().getDataContext(GotoActionModel.this.myContextComponent);
                    AnActionEvent event = GotoActionModel.updateActionBeforeShow(anAction, dataContext);
                    Presentation presentation = event.getPresentation();
                    Color fg = GotoActionModel.defaultActionForeground(isSelected, presentation);
                    JLabel actionLabel = GotoActionModel.this.createActionLabel(anAction, templatePresentation.getText(), fg, bg, icon);
                    panel.add((Component)actionLabel, "West");
                    String groupName = (String)actionWithParentGroup.getValue();
                    if (groupName != null) {
                        JLabel groupLabel = new JLabel(groupName);
                        groupLabel.setBackground(bg);
                        groupLabel.setForeground(fg);
                        panel.add((Component)groupLabel, "East");
                    }
                } else if (value instanceof OptionDescription) {
                    String hit;
                    if (!isSelected && !UIUtil.isUnderDarcula()) {
                        panel.setBackground(LightColors.SLIGHTLY_GRAY);
                    }
                    if ((hit = ((OptionDescription)value).getHit()) == null) {
                        hit = ((OptionDescription)value).getOption();
                    }
                    if ((hit = StringUtil.unescapeXml((String)hit)).length() > 60) {
                        hit = hit.substring(0, 60) + "...";
                    }
                    hit = hit.replace("  ", " ");
                    Color fg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
                    JLabel label = new JLabel(hit.trim());
                    label.setIcon(EMPTY_ICON);
                    label.setForeground(fg);
                    label.setBackground(bg);
                    panel.add((Component)label, "West");
                    JLabel settingsLabel = new JLabel("Settings");
                    settingsLabel.setForeground(fg);
                    settingsLabel.setBackground(bg);
                    panel.add((Component)settingsLabel, "East");
                } else if (value instanceof String) {
                    JBLabel label = new JBLabel((String)value);
                    label.setIcon(EMPTY_ICON);
                    panel.add((Component)label, "West");
                }
                return panel;
            }
        };
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/GotoActionModel", "getActionId"));
        }
        return this.myActionManager.getId(anAction);
    }

    protected JLabel createActionLabel(AnAction anAction, String anActionName, Color fg, Color bg, Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconWidth() <= EMPTY_ICON.getIconWidth() && icon.getIconHeight() <= EMPTY_ICON.getIconHeight()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        Shortcut shortcut = GotoActionModel.preferKeyboardShortcut(KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.getActionId(anAction)));
        String actionName = anActionName + (shortcut != null ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")" : "");
        JLabel actionLabel = new JLabel(actionName, (Icon)layeredIcon, 2);
        actionLabel.setBackground(bg);
        actionLabel.setForeground(fg);
        return actionLabel;
    }

    private static Shortcut preferKeyboardShortcut(Shortcut[] shortcuts) {
        if (shortcuts != null) {
            for (Shortcut shortcut : shortcuts) {
                if (!shortcut.isKeyboard()) continue;
                return shortcut;
            }
            return shortcuts.length > 0 ? shortcuts[0] : null;
        }
        return null;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Map.Entry && !(o2 instanceof Map.Entry)) {
            return -1;
        }
        if (o2 instanceof Map.Entry && !(o1 instanceof Map.Entry)) {
            return 1;
        }
        return StringUtil.compare((String)this.getFullName(o1), (String)this.getFullName(o2), (boolean)true);
    }

    public static AnActionEvent updateActionBeforeShow(AnAction anAction, DataContext dataContext) {
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)false);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)true);
        return event;
    }

    protected static Color defaultActionForeground(boolean isSelected, Presentation presentation) {
        if (isSelected) {
            return UIUtil.getListSelectionForeground();
        }
        if (!presentation.isEnabled() || !presentation.isVisible()) {
            return UIUtil.getInactiveTextColor();
        }
        return UIUtil.getListForeground();
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(INTENTIONS_KEY);
        for (AnAction action : this.myActionsMap.keySet()) {
            result.add(this.getActionId(action));
        }
        if (checkBoxState) {
            Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
            for (String id : ids) {
                result.add(id);
            }
        }
        result.add(SETTINGS_KEY);
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        HashMap<AnAction, String> map;
        block12: {
            block11: {
                map = new HashMap<AnAction, String>();
                AnAction act = this.myActionManager.getAction(id);
                if (act == null) break block11;
                map.put(act, this.myActionsMap.get(act));
                if (!checkBoxState) break block12;
                Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
                for (AnAction action : map.keySet()) {
                    ids.remove(this.getActionId(action));
                }
                if (!ids.contains(id)) break block12;
                AnAction anAction = this.myActionManager.getAction(id);
                map.put(anAction, null);
                break block12;
            }
            if (Comparing.strEqual((String)id, (String)INTENTIONS_KEY)) {
                for (String intentionText : this.myIntentions.keySet()) {
                    ApplyIntentionAction intentionAction = this.myIntentions.get(intentionText);
                    if (!this.actionMatches(pattern, intentionAction)) continue;
                    map.put(intentionAction, intentionText);
                }
            }
        }
        Object[] objects = map.entrySet().toArray(new Map.Entry[map.size()]);
        if (Comparing.strEqual((String)id, (String)SETTINGS_KEY)) {
            Set words = this.myIndex.getProcessedWords(pattern);
            Set<OptionDescription> optionDescriptions = null;
            String actionManagerName = this.myActionManager.getComponentName();
            for (String word : words) {
                Set<OptionDescription> descriptions = ((SearchableOptionsRegistrarImpl)this.myIndex).getAcceptableDescriptions(word);
                if (descriptions != null) {
                    Iterator<OptionDescription> iterator = descriptions.iterator();
                    while (iterator.hasNext()) {
                        OptionDescription description = iterator.next();
                        if (!actionManagerName.equals(description.getPath())) continue;
                        iterator.remove();
                    }
                    if (descriptions.isEmpty()) continue;
                    if (optionDescriptions == null) {
                        optionDescriptions = descriptions;
                        continue;
                    }
                    optionDescriptions.retainAll(descriptions);
                    continue;
                }
                optionDescriptions = null;
                break;
            }
            if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
                HashSet<String> currentHits = new HashSet<String>();
                Iterator iterator = optionDescriptions.iterator();
                while (iterator.hasNext()) {
                    OptionDescription description = (OptionDescription)iterator.next();
                    String hit = description.getHit();
                    if (hit != null && currentHits.add(hit.trim())) continue;
                    iterator.remove();
                }
                Object[] descriptions = optionDescriptions.toArray();
                Arrays.sort(descriptions);
                objects = ArrayUtil.mergeArrays((Object[])objects, (Object[])descriptions);
            }
        }
        if (objects == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getElementsByName"));
        }
        return objects;
    }

    private void collectActions(Map<AnAction, String> result, ActionGroup group, String containingGroupName) {
        AnAction[] actions = group.getChildren(null);
        this.includeGroup(result, group, actions, containingGroupName);
        for (AnAction action : actions) {
            if (action == null) continue;
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup;
                String groupName = (actionGroup = (ActionGroup)action).getTemplatePresentation().getText();
                this.collectActions(result, actionGroup, StringUtil.isEmpty((String)groupName) || !actionGroup.isPopup() ? containingGroupName : groupName);
                continue;
            }
            String groupName = group.getTemplatePresentation().getText();
            if (result.containsKey(action)) {
                result.put(action, null);
                continue;
            }
            result.put(action, StringUtil.isEmpty((String)groupName) ? containingGroupName : groupName);
        }
    }

    private void includeGroup(Map<AnAction, String> result, ActionGroup group, AnAction[] actions, String containingGroupName) {
        boolean showGroup = true;
        for (AnAction action : actions) {
            if (this.myActionManager.getId(action) == null) continue;
            showGroup = false;
            break;
        }
        if (showGroup) {
            result.put((AnAction)group, containingGroupName);
        }
    }

    @Nullable
    public String getFullName(Object element) {
        return this.getElementName(element);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getSeparators"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getElementName(Object element) {
        if (element instanceof OptionDescription) {
            return ((OptionDescription)element).getHit();
        }
        if (!(element instanceof Map.Entry)) {
            return null;
        }
        return ((AnAction)((Map.Entry)element).getKey()).getTemplatePresentation().getText();
    }

    @Override
    public boolean matches(@NotNull String name, @NotNull String pattern) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/GotoActionModel", "matches"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/GotoActionModel", "matches"));
        }
        AnAction anAction = this.myActionManager.getAction(name);
        if (anAction == null) {
            return true;
        }
        return this.actionMatches(pattern, anAction);
    }

    protected boolean actionMatches(String pattern, @NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/GotoActionModel", "actionMatches"));
        }
        Pattern compiledPattern = this.getPattern(pattern);
        Presentation presentation = anAction.getTemplatePresentation();
        String text = presentation.getText();
        String description = presentation.getDescription();
        PatternMatcher matcher = this.getMatcher();
        if (text != null && matcher.matches(text, compiledPattern) || description != null && !description.equals(text) && matcher.matches(description, compiledPattern)) {
            return true;
        }
        String groupName = this.myActionsMap.get(anAction);
        return groupName != null && text != null && matcher.matches(groupName + " " + text, compiledPattern);
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    private Pattern getPattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/GotoActionModel", "getPattern"));
        }
        String converted = this.convertPattern(pattern.trim());
        Pattern compiledPattern = this.myCompiledPattern;
        if (compiledPattern != null && !Comparing.strEqual((String)converted, (String)compiledPattern.getPattern())) {
            compiledPattern = null;
        }
        if (compiledPattern == null) {
            try {
                this.myCompiledPattern = compiledPattern = new Perl5Compiler().compile(converted, 32768);
            }
            catch (MalformedPatternException e) {
                // empty catch block
            }
        }
        Pattern pattern2 = compiledPattern;
        if (pattern2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getPattern"));
        }
        return pattern2;
    }

    private String convertPattern(String pattern) {
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 80) {
            pattern = pattern.substring(0, 80);
        }
        StringBuilder buffer = new StringBuilder();
        boolean allowToLower = true;
        if (GotoActionModel.containsOnlyUppercaseLetters(pattern)) {
            allowToLower = false;
        }
        if (allowToLower) {
            buffer.append(".*");
        }
        boolean firstIdentifierLetter = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    if (!firstIdentifierLetter) {
                        buffer.append("[^A-Z]*");
                    }
                    buffer.append("[");
                    buffer.append(c);
                    if (allowToLower || i == 0) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    buffer.append("]");
                } else if (Character.isLowerCase(c)) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append('|');
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                buffer.append("\\.");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("[^A-Z]*\\ ");
                firstIdentifierLetter = true;
                continue;
            }
            firstIdentifierLetter = true;
            buffer.append("\\x");
            buffer.append(Integer.toHexString(c + 131072).substring(3));
        }
        buffer.append(".*");
        return buffer.toString();
    }

    private static boolean containsOnlyUppercaseLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*' || c == ' ' || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return false;
    }

    private PatternMatcher getMatcher() {
        return this.myMatcher.get();
    }
}

