/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultClassNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            this.processNames((Processor<String>)processor, scope, IdFilter.getProjectIdFilter((Project)project, (boolean)includeNonProjectItems));
            String[] stringArray = ArrayUtil.toStringArray((Collection)processor.getResults());
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "getNames"));
            }
            return stringArray;
        }
        String[] stringArray = PsiShortNamesCache.getInstance((Project)project).getAllClassNames();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsWithName(name, (Processor<NavigationItem>)processor, FindSymbolParameters.wrap(pattern, project, includeNonProjectItems));
        NavigationItem[] navigationItemArray = (NavigationItem[])processor.toArray((Object[])new NavigationItem[processor.getResults().size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    public static String getQualifiedNameForClass(PsiClass psiClass) {
        String qName = psiClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        String containerText = SymbolPresentationUtil.getSymbolContainerText((PsiElement)psiClass);
        return containerText + "." + psiClass.getName();
    }

    public String getQualifiedNameSeparator() {
        return ".";
    }

    @Override
    public void processNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "processNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "processNames"));
        }
        PsiShortNamesCache.getInstance((Project)scope.getProject()).processAllClassNames(processor, scope, filter);
    }

    @Override
    public void processElementsWithName(@NotNull String name, final @NotNull Processor<NavigationItem> processor, final @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "processElementsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "processElementsWithName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/gotoByName/DefaultClassNavigationContributor", "processElementsWithName"));
        }
        PsiShortNamesCache.getInstance((Project)parameters.getProject()).processClassesWithName(name, (Processor)new Processor<PsiClass>(){
            final boolean isAnnotation;
            {
                this.isAnnotation = parameters.getLocalPatternName().startsWith("@");
            }

            public boolean process(PsiClass aClass) {
                if (aClass.getContainingFile().getVirtualFile() == null || !aClass.isPhysical()) {
                    return true;
                }
                if (this.isAnnotation && !aClass.isAnnotationType()) {
                    return true;
                }
                return processor.process((Object)aClass);
            }
        }, parameters.getSearchScope(), parameters.getIdFilter());
    }
}

