/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CustomLibraryDescriptionBase
extends CustomLibraryDescription {
    private final String myDefaultLibraryName;

    protected CustomLibraryDescriptionBase(@NotNull String defaultLibraryName) {
        if (defaultLibraryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/CustomLibraryDescriptionBase", "<init>"));
        }
        this.myDefaultLibraryName = defaultLibraryName;
    }

    @Override
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/CustomLibraryDescriptionBase", "createNewLibrary"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, false, false, true);
        descriptor.setTitle(IdeBundle.message((String)"new.library.file.chooser.title", (Object[])new Object[0]));
        descriptor.setDescription(IdeBundle.message((String)"new.library.file.chooser.description", (Object[])new Object[0]));
        final VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Component)parentComponent, null, (VirtualFile)contextDirectory);
        if (files.length == 0) {
            return null;
        }
        return new NewLibraryConfiguration(this.myDefaultLibraryName, this.getDownloadableLibraryType(), new LibraryVersionProperties()){

            @Override
            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/CustomLibraryDescriptionBase$1", "addRoots"));
                }
                for (VirtualFile file : files) {
                    editor.addRoot(file, OrderRootType.CLASSES);
                }
            }
        };
    }
}

