/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserDialog;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeFileChooserFactoryImpl
extends TreeFileChooserFactory {
    private final Project myProject;

    public TreeFileChooserFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, false, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, showLibraryContents);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }
}

