/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipPanel;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TipDialog
extends DialogWrapper {
    private final TipPanel myTipPanel;

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public TipDialog() {
        super(true);
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel();
        this.myTipPanel.nextTip();
        this.setHorizontalStretch(1.33f);
        this.setVerticalStretch(1.25f);
        this.init();
        if (this.getPeer() instanceof DialogWrapperPeerImpl) {
            ((DialogWrapperPeerImpl)this.getPeer()).setAutoRequestFocus(false);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new PreviousTipAction(), new NextTipAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    public void dispose() {
        super.dispose();
    }

    private class NextTipAction
    extends AbstractAction {
        public NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipDialog.this.myTipPanel.nextTip();
            UsageTrigger.trigger("tips.of.the.day.next");
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        public PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipDialog.this.myTipPanel.prevTip();
            UsageTrigger.trigger("tips.of.the.day.prev");
        }
    }
}

