/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TraverseUIStarter
implements ApplicationStarter {
    private String OUTPUT_PATH;
    @NonNls
    private static final String OPTIONS = "options";
    @NonNls
    private static final String CONFIGURABLE = "configurable";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String CONFIGURABLE_NAME = "configurable_name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String HIT = "hit";

    @NonNls
    public String getCommandName() {
        return "traverseUI";
    }

    public void premain(String[] args) {
        this.OUTPUT_PATH = args[1];
    }

    public void main(String[] args) {
        System.out.println("Starting searchable options index builder");
        try {
            this.startup();
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void startup() throws IOException {
        HashMap<SearchableConfigurable, TreeSet<OptionDescription>> options = new HashMap<SearchableConfigurable, TreeSet<OptionDescription>>();
        SearchUtil.processProjectConfigurables(ProjectManager.getInstance().getDefaultProject(), options);
        Element root = new Element(OPTIONS);
        for (SearchableConfigurable configurable : options.keySet()) {
            UnnamedConfigurable wrapped;
            Element configurableElement = new Element(CONFIGURABLE);
            String id = configurable.getId();
            if (id == null) continue;
            configurableElement.setAttribute(ID, id);
            configurableElement.setAttribute(CONFIGURABLE_NAME, configurable.getDisplayName());
            TreeSet<OptionDescription> sortedOptions = options.get(configurable);
            TraverseUIStarter.writeOptions(configurableElement, sortedOptions);
            if (configurable instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable).getConfigurable()) instanceof SearchableConfigurable) {
                configurable = (SearchableConfigurable)wrapped;
            }
            if (configurable instanceof KeymapPanel) {
                TraverseUIStarter.processKeymap(configurableElement);
            } else if (configurable instanceof OptionsContainingConfigurable) {
                TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable, configurableElement);
            } else if (configurable instanceof PluginManagerConfigurable) {
                TreeSet<OptionDescription> descriptions = TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton("Manage repositories..."));
                for (OptionDescription description : descriptions) {
                    TraverseUIStarter.append(null, "Manage repositories...", description.getOption(), configurableElement);
                }
            } else if (configurable instanceof AllFileTemplatesConfigurable) {
                TraverseUIStarter.processFileTemplates(configurableElement);
            }
            root.addContent(configurableElement);
            configurable.disposeUIResources();
        }
        File file = new File(this.OUTPUT_PATH);
        if (!file.isFile()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        JDOMUtil.writeDocument((Document)new Document(root), (String)this.OUTPUT_PATH, (String)"\n");
        System.out.println("Searchable options index builder completed");
        ((ApplicationEx)ApplicationManager.getApplication()).exit(true);
    }

    private static void processFileTemplates(Element configurableElement) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        TreeSet<OptionDescription> options = new TreeSet<OptionDescription>();
        TraverseUIStarter.processTemplates(optionsRegistrar, options, FileTemplateManager.getInstance().getAllTemplates());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, FileTemplateManager.getInstance().getAllPatterns());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, FileTemplateManager.getInstance().getAllCodeTemplates());
        TraverseUIStarter.processTemplates(optionsRegistrar, options, FileTemplateManager.getInstance().getAllJ2eeTemplates());
        TraverseUIStarter.writeOptions(configurableElement, options);
    }

    private static void processTemplates(SearchableOptionsRegistrar optionsRegistrar, TreeSet<OptionDescription> options, FileTemplate[] templates) {
        for (FileTemplate template : templates) {
            TraverseUIStarter.collectOptions(optionsRegistrar, options, template.getName());
        }
    }

    private static void collectOptions(SearchableOptionsRegistrar optionsRegistrar, TreeSet<OptionDescription> options, String text) {
        TraverseUIStarter.collectOptions(optionsRegistrar, options, text, null);
    }

    private static void collectOptions(SearchableOptionsRegistrar optionsRegistrar, TreeSet<OptionDescription> options, String text, String path) {
        Set strings = optionsRegistrar.getProcessedWordsWithoutStemming(text);
        for (String word : strings) {
            options.add(new OptionDescription(word, text, path));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable, Element configurableElement) {
        Set<String> optionsPath = configurable.processListOptions();
        TreeSet<OptionDescription> result = TraverseUIStarter.wordsToOptionDescriptors(optionsPath);
        TraverseUIStarter.writeOptions(configurableElement, result);
    }

    private static TreeSet<OptionDescription> wordsToOptionDescriptors(Set<String> optionsPath) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        TreeSet<OptionDescription> result = new TreeSet<OptionDescription>();
        for (String opt : optionsPath) {
            Set words = searchableOptionsRegistrar.getProcessedWordsWithoutStemming(opt);
            for (String word : words) {
                if (word == null) continue;
                result.add(new OptionDescription(word, opt, null));
            }
        }
        return result;
    }

    private static void processKeymap(Element configurableElement) {
        ActionManager actionManager = ActionManager.getInstance();
        String componentName = actionManager.getComponentName();
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set<String> ids = ((ActionManagerImpl)actionManager).getActionIds();
        TreeSet<OptionDescription> options = new TreeSet<OptionDescription>();
        for (String id : ids) {
            String description;
            AnAction anAction = actionManager.getAction(id);
            String text = anAction.getTemplatePresentation().getText();
            if (text != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, text, componentName);
            }
            if ((description = anAction.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options, description, componentName);
        }
        TraverseUIStarter.writeOptions(configurableElement, options);
    }

    private static void writeOptions(Element configurableElement, TreeSet<OptionDescription> options) {
        for (OptionDescription opt : options) {
            TraverseUIStarter.append(opt.getPath(), opt.getHit(), opt.getOption(), configurableElement);
        }
    }

    private static void append(String path, String hit, String word, Element configurableElement) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        configurableElement.addContent(optionElement);
    }
}

