/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import javax.swing.Icon;

public class DarculaInstaller {
    public static void uninstall() {
        EditorColorsScheme scheme;
        JBColor.setDark((boolean)false);
        IconLoader.setUseDarkIcons((boolean)false);
        if ("Darcula".equals(EditorColorsManager.getInstance().getGlobalScheme().getName()) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            EditorColorsManager.getInstance().setGlobalScheme(scheme);
        }
        DarculaInstaller.update();
    }

    private static void update() {
        Project[] openProjects;
        UISettings.getInstance().fireUISettingsChanged();
        EditorFactory.getInstance().refreshAllEditors();
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance((Project)project).fileStatusesChanged();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
        for (Project project : WindowManagerEx.getInstanceEx().getAllProjectFrames()) {
            if (!(project instanceof IdeFrameImpl)) continue;
            ((IdeFrameImpl)project).updateView();
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
        DarculaInstaller.restart();
    }

    private static void restart() {
        if (Messages.showOkCancelDialog((String)"You must restart the IDE to changes take effect. Restart now?", (String)"Restart Is Required", (String)"Restart", (String)"Postpone", (Icon)Messages.getQuestionIcon()) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public static void install() {
        EditorColorsScheme scheme;
        JBColor.setDark((boolean)true);
        IconLoader.setUseDarkIcons((boolean)true);
        if (!"Darcula".equals(EditorColorsManager.getInstance().getGlobalScheme().getName()) && (scheme = EditorColorsManager.getInstance().getScheme("Darcula")) != null) {
            EditorColorsManager.getInstance().setGlobalScheme(scheme);
        }
        DarculaInstaller.update();
    }
}

