/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.DaemonCodeAnalyzerOptionDescription;
import com.intellij.ide.ui.EditorOptionDescription;
import com.intellij.ide.ui.UISettingsOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;

public class UISimpleSettingsProvider
implements SearchTopHitProvider {
    private static OptionDescription CYCLING_SCROLLING = new UISettingsOptionDescription("CYCLING_SCROLLING", "Cyclic scrolling", "appearance");
    private static OptionDescription MEMORY_INDICATOR = new UISettingsOptionDescription("SHOW_MEMORY_INDICATOR", "Show Memory Indicator", "appearance");
    private static OptionDescription SHOW_MAIN_TOOLBAR = new UISettingsOptionDescription("SHOW_MAIN_TOOLBAR", "Show Main Toolbar", "appearance");
    private static OptionDescription SHOW_NAVIGATION_BAR = new UISettingsOptionDescription("SHOW_NAVIGATION_BAR", "Show Navigation Bar", "appearance");
    private static OptionDescription HIDE_TOOL_STRIPES = new UISettingsOptionDescription("HIDE_TOOL_STRIPES", "Hide Tool Window Bars", "appearance");
    private static OptionDescription SHOW_STATUS_BAR = new UISettingsOptionDescription("SHOW_STATUS_BAR", "Show Status Bar", "appearance");
    private static OptionDescription IS_BLOCK_CURSOR = new EditorOptionDescription("IS_BLOCK_CURSOR", "Show Block Cursor", "appearance");
    private static OptionDescription IS_WHITESPACES_SHOWN = new EditorOptionDescription("IS_WHITESPACES_SHOWN", "Show Whitespaces", "appearance");
    private static OptionDescription ARE_LINE_NUMBERS_SHOWN = new EditorOptionDescription("ARE_LINE_NUMBERS_SHOWN", "Show Line Numbers", "appearance");
    private static OptionDescription SHOW_METHOD_SEPARATORS = new DaemonCodeAnalyzerOptionDescription("SHOW_METHOD_SEPARATORS", "Show Method Separators", "appearance");

    public void consumeTopHits(String pattern, Consumer<Object> collector) {
        if (StringUtil.isBetween((String)(pattern = pattern.trim().toLowerCase()), (String)"cyc", (String)"cyclic ") || StringUtil.isBetween((String)pattern, (String)"scr", (String)"scroll ")) {
            collector.consume((Object)CYCLING_SCROLLING);
        } else if (UISimpleSettingsProvider.patternContains(pattern, "memo")) {
            collector.consume((Object)MEMORY_INDICATOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"nav", (String)"navigation bar ") || StringUtil.isBetween((String)pattern, (String)"navb", (String)"navbar ")) {
            collector.consume((Object)SHOW_NAVIGATION_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool", (String)"toolbar ")) {
            collector.consume((Object)SHOW_MAIN_TOOLBAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool w", (String)"tool window bars") || StringUtil.isBetween((String)pattern, (String)"toolw", (String)"toolwindow ")) {
            collector.consume((Object)HIDE_TOOL_STRIPES);
        } else if (StringUtil.isBetween((String)pattern, (String)"stat", (String)"status bar ")) {
            collector.consume((Object)SHOW_STATUS_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"curs", (String)"cursor ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block cursor ") || StringUtil.isBetween((String)pattern, (String)"caret", (String)"caret ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block caret ")) {
            collector.consume((Object)IS_BLOCK_CURSOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"whites", (String)"whitespaces ") || StringUtil.isBetween((String)pattern, (String)"show whi", (String)"show whitespaces ")) {
            collector.consume((Object)IS_WHITESPACES_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"line ", (String)"line numbers ") || StringUtil.isBetween((String)pattern, (String)"show li", (String)"show line numbers ")) {
            collector.consume((Object)ARE_LINE_NUMBERS_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"separa ", (String)"separators ") || StringUtil.isBetween((String)pattern, (String)"method s", (String)"method separators ")) {
            collector.consume((Object)SHOW_METHOD_SEPARATORS);
        }
    }

    private static boolean patternContains(String pattern, String search) {
        for (String s : pattern.split(" ")) {
            if (!s.contains(search)) continue;
            return true;
        }
        return false;
    }
}

